/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventrouting;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;

public class Test1108095Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    public static final String SERVICE3_DU_PATH_PARAM = "service3DUPath";
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private static final String testName = "Test1108095";
    private static final int MAX_SEQ = -5;
    private int prevSeq = 20;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test1108095InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
        this.setupService(SERVICE3_DU_PATH_PARAM, true);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            int seq = (Integer)message.getMessage();
            Test1108095Test.this.getLog().info("Received message from SBB with seq number = " + seq);
            if (seq >= Test1108095Test.this.prevSeq) {
                Test1108095Test.this.result.setFailed(1108095, "Root SBBs of services with differing default priorities received their initial events in the wrong order.");
                return;
            }
            if (seq == -5) {
                Test1108095Test.this.result.setPassed();
                return;
            }
            Test1108095Test.this.prevSeq = seq;
        }

        public void onException(Exception e) throws RemoteException {
            Test1108095Test.this.getLog().warning("Received exception from SBB");
            Test1108095Test.this.getLog().warning(e);
            Test1108095Test.this.result.setError(e);
        }
    }
}

