/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class Test1108196Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    public static final String activityNameA = "Test1108196Test-ActivityA";
    public static final String activityNameB = "Test1108196Test-ActivityB";
    private static final int defaultTimeout = 25000;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private int receivedCountSbb1 = 0;
    private int receivedCountSbb2 = 0;
    private int expectedCountSbb1;
    private int expectedCountSbb2;
    private String testName = "Test1108196";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityA = resource.createActivity(activityNameA);
        TCKActivityID activityB = resource.createActivity(activityNameB);
        this.getLog().fine("Firing TCKResourceEventX1 on Test1108196Test-ActivityA.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityA, null);
        this.expectedCountSbb1 = 1;
        this.expectedCountSbb2 = 0;
        Test1108196Test test1108196Test = this;
        synchronized (test1108196Test) {
            this.wait(1000L);
        }
        if (this.expectedCountSbb1 != this.receivedCountSbb1 || this.receivedCountSbb2 != this.expectedCountSbb2) {
            result.setFailed(1108196, "First check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
            return;
        }
        this.getLog().fine("Firing TCKResourceEventX2 on Test1108196Test-ActivityB.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", this.testName, activityB, null);
        this.expectedCountSbb1 = 2;
        this.expectedCountSbb2 = 1;
        test1108196Test = this;
        synchronized (test1108196Test) {
            this.wait(1000L);
        }
        if (this.expectedCountSbb1 != this.receivedCountSbb1 || this.receivedCountSbb2 != this.expectedCountSbb2) {
            result.setFailed(1108196, "Second check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
            return;
        }
        this.expectedCountSbb1 = 2;
        this.expectedCountSbb2 = 2;
        if (this.getTestName().equals("NOTIMEOUT")) {
            test1108196Test = this;
            synchronized (test1108196Test) {
                this.wait(30000L);
            }
        } else if (this.getTestName().equals("TIMEOUT")) {
            test1108196Test = this;
            synchronized (test1108196Test) {
                this.wait(5000L);
            }
        } else {
            result.setError("Unexpected test name encountered during test run: " + this.getTestName());
            return;
        }
        if (this.expectedCountSbb1 != this.receivedCountSbb1 || this.receivedCountSbb2 != this.expectedCountSbb2) {
            result.setFailed(1108197, "Second check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
            return;
        }
        this.getLog().fine("Firing TCKResourceEventX3 on Test1108196Test-ActivityA and Test1108196Test-ActivityB.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", this.testName, activityA, null);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", this.testName, activityB, null);
        this.getLog().fine("Waiting for test pass indicator from SBB.");
        this.expectedCountSbb2 = 4;
        this.expectedCountSbb1 = 4;
        test1108196Test = this;
        synchronized (test1108196Test) {
            this.wait(18000L);
        }
        if (this.expectedCountSbb1 == this.receivedCountSbb1 && this.receivedCountSbb2 == this.expectedCountSbb2) {
            result.setPassed();
        } else {
            result.setFailed(1108197, "Fourth check: Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + (this.expectedCountSbb1 + this.expectedCountSbb2) + ", received " + (this.receivedCountSbb1 + this.receivedCountSbb2) + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.testName = this.getTestName();
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public String getTestName() {
        String testName = "testName";
        return this.utils().getTestParams().getProperty(testName);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108196Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108196Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                if (sbbTestMessage.contains("Sbb1")) {
                    Test1108196Test.this.receivedCountSbb1++;
                } else if (sbbTestMessage.contains("Sbb2")) {
                    Test1108196Test.this.receivedCountSbb2++;
                }
            }
            catch (TCKTestFailureException ex) {
                Test1108196Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108196Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108196Test.this.getLog().warning(exception);
            Test1108196Test.this.result.setError(exception);
        }
    }
}

