/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class Test1108180Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    public static final String activityNameA = "Test1108180Test-ActivityA";
    public static final String activityNameB = "Test1108180Test-ActivityB";
    private static final int defaultTimeout = 25000;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private String testName = "Test1108180";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityA = resource.createActivity(activityNameA);
        TCKActivityID activityB = resource.createActivity(activityNameB);
        this.getLog().fine("Firing TCKResourceEventX1 on Test1108180Test-ActivityA.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityA, null);
        Test1108180Test test1108180Test = this;
        synchronized (test1108180Test) {
            this.wait(3000L);
        }
        this.getLog().fine("Firing TCKResourceEventX2 on Test1108180Test-ActivityB.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", this.testName, activityB, null);
        if (this.getTestName().equals("NOTIMEOUT")) {
            test1108180Test = this;
            synchronized (test1108180Test) {
                this.wait(25000L);
            }
        } else if (!this.getTestName().equals("TIMEOUT")) {
            result.setError("Unexpected test name encountered during test run: " + this.getTestName());
            return;
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.testName = this.getTestName();
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public String getTestName() {
        String testName = "testName";
        return this.utils().getTestParams().getProperty(testName);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108180Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108180Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1108180Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1108180Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108180Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108180Test.this.getLog().warning(exception);
            Test1108180Test.this.result.setError(exception);
        }
    }
}

