/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.facilities.Tracer;

public abstract class Test1108043Sbb1
extends BaseTCKSbb {
    public static final String TRACE_MESSAGE_TCKResourceEventX1 = "Test1108043Sbb1:I got TCKResourceEventX1 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2A = "Test1108043Sbb1:I got TCKResourceEventX2 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2B = "Test1108043Sbb1:I got TCKResourceEventX2 on ActivityB";
    public static final String TRACE_MESSAGE_TCKResourceEventX3 = "Test1108043Sbb1:I got TCKResourceEventX3 on ActivityB";
    private Tracer tracer = null;

    public InitialEventSelector initialEventSelector(InitialEventSelector ies) {
        ies.setCustomName("test");
        return ies;
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX1);
            this.setEventContext(context);
            context.suspendDelivery();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            TCKActivity activity = (TCKActivity)context.getActivityContextInterface().getActivity();
            TCKActivityID activityID = activity.getID();
            if (activityID.getName().equals("Test1108043Test-ActivityB")) {
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2B);
                EventContext ec = this.getEventContext();
                try {
                    ec.resumeDelivery();
                }
                catch (Exception e) {
                    this.tracer.severe("ERROR onTCKResourceEventX2, the event delivery failed to be resumed");
                    this.sendResultToTCK("Test1108043Test", false, "SBB1:onTCKResourceEventX2-ERROR: The event delivery failed to be resumed", 1108043);
                    return;
                }
                this.tracer.info("Test1108043Sbb1: onTCKResourceEventX2- Enter Rollback.");
                this.getSbbContext().setRollbackOnly();
                this.tracer.info("Test1108043Sbb1: onTCKResourceEventX2- Exit Rollback.");
                if (!this.getSbbContext().getRollbackOnly()) {
                    try {
                        if (ec.isSuspended()) {
                            ec.resumeDelivery();
                        }
                    }
                    catch (Exception e) {
                        this.tracer.severe("Failed to resume the suspended event delivery.");
                    }
                }
                return;
            }
            if (activityID.getName().equals("Test1108043Test-ActivityA")) {
                this.tracer = this.getSbbContext().getTracer("com.test");
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2A);
                if (!this.getPassed()) {
                    this.sendResultToTCK("Test1108043Test", false, "SBB1:onTCKResourceEventX2-ERROR: When the transaction does not commit, then the Event Context will not be resumed, and the event should not been delivered to the event'sdelivered set.", 1108043);
                }
                return;
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX3);
            this.setPassed(true);
            if (context.isSuspended()) {
                this.sendResultToTCK("Test1108043Test", false, "SBB1:onTCKResourceEventX3-ERROR: The event delivery should not be suspended, the EventContext.isSuspended() returned true!", 1108043);
                return;
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public abstract void setEventContext(EventContext var1);

    public abstract EventContext getEventContext();

    private void sendResultToTCK(String testName, boolean result, String message, int failedAssertionID) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setPassed(boolean var1);

    public abstract boolean getPassed();
}

