/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.facilities.Tracer;

public abstract class Test1108029Sbb1
extends BaseTCKSbb {
    public static final String TRACE_MESSAGE_TCKResourceEventX1 = "Test1108029Sbb1:I got TCKResourceEventX1 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2 = "Test1108029Sbb1:I got TCKResourceEventX2 on ActivityB";
    public static final String TRACE_MESSAGE_TCKResourceEventX3 = "Test1108029Sbb1:I got TCKResourceEventX3 on ActivityB";
    private Tracer tracer = null;

    public InitialEventSelector initialEventSelector(InitialEventSelector ies) {
        ies.setCustomName("test");
        return ies;
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX1);
            this.setTestName((String)event.getMessage());
            this.setEventContext(context);
            if (this.getTestName().equals("TIMEOUT")) {
                context.suspendDelivery(10000);
            } else if (this.getTestName().equals("NOTIMEOUT")) {
                context.suspendDelivery();
            } else {
                this.tracer.severe("Unexpected test name encountered during X1 event handler: " + this.getTestName());
                return;
            }
            boolean passed = false;
            try {
                context.suspendDelivery();
            }
            catch (IllegalStateException e) {
                this.tracer.info("got expected IllegalStateException if the event delivery has already been suspended.");
                passed = true;
            }
            if (!passed) {
                this.sendResultToTCK("Test1108029Test", false, "SBB1:onTCKResourceEventX1-ERROR: EventContext.suspendDelivery() should have thrown java.lang.IllegalStateException if the event delivery has already been suspended.", 1108029);
                return;
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2);
            EventContext ec = this.getEventContext();
            if (!ec.isSuspended()) {
                this.sendResultToTCK("Test1108029Test", false, "SBB1:onTCKResourceEventX2-ERROR: ERROR onTCKResourceEventX2, the event delivery hasn't been suspended, the EventContext.isSuspended() returned false!", 1108029);
                return;
            }
            boolean passed = false;
            try {
                ec.suspendDelivery();
            }
            catch (IllegalStateException e) {
                this.tracer.info("got expected IllegalStateException if the event delivery has already been suspended.");
                passed = true;
            }
            if (!passed) {
                this.sendResultToTCK("Test1108029Test", false, "SBB1:onTCKResourceEventX2-ERROR: EventContext.suspendDelivery() should have thrown java.lang.IllegalStateException if the event delivery has already been suspended.", 1108029);
                return;
            }
            this.sendResultToTCK("Test1108029Test", true, "Test The javax.slee.IllegalStateException is thrown if the event delivery has already been suspended or suspendDelivery is invoked on an Event Context object that is not the Event Context object provided by the SLEE to the event handler method invoked by the SLEE passed.", 1108029);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX3);
            EventContext ec = this.getEventContext();
            try {
                if (ec != null && ec.isSuspended()) {
                    ec.resumeDelivery();
                }
            }
            catch (Exception e) {
                this.tracer.severe("Failed to resume the suspended event delivery.");
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, String message, int failedAssertionID) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setEventContext(EventContext var1);

    public abstract EventContext getEventContext();

    public abstract void setTestName(String var1);

    public abstract String getTestName();
}

