/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.facilities.Tracer;

public abstract class Test1108023Sbb
extends BaseTCKSbb {
    public static final String TRACE_MESSAGE_TCKResourceEventX1 = "Test1108023Sbb:I got TCKResourceEventX1 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2A = "Test1108023Sbb:I got TCKResourceEventX2 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2B = "Test1108023Sbb:I got TCKResourceEventX2 on ActivityB";
    public static final String TRACE_MESSAGE_TCKResourceEventX3 = "Test1108023Sbb:I got TCKResourceEventX3 on ActivityA";
    public static int waitPeriodMs = 15000;
    private Tracer tracer = null;

    public InitialEventSelector initialEventSelector(InitialEventSelector ies) {
        ies.setCustomName("test");
        return ies;
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        block4: {
            try {
                this.tracer = this.getSbbContext().getTracer("com.test");
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX1);
                this.setTestName((String)event.getMessage());
                this.setEventContext(context);
                if (this.getTestName().equals("TIMEOUT")) {
                    context.suspendDelivery(waitPeriodMs);
                    break block4;
                }
                if (this.getTestName().equals("NOTIMEOUT")) {
                    context.suspendDelivery();
                    break block4;
                }
                this.tracer.severe("Unexpected test name encountered during X1 event handler: " + this.getTestName());
                return;
            }
            catch (Exception e) {
                TCKSbbUtils.handleException(e);
            }
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            TCKActivity activity = (TCKActivity)context.getActivityContextInterface().getActivity();
            TCKActivityID activityID = activity.getID();
            this.tracer.info("Received " + activityID.getName());
            if (activityID.getName().equals("Test1108023Test-ActivityB")) {
                this.tracer.info("Received Test1108023Sbb:I got TCKResourceEventX2 on ActivityB");
                EventContext ec = this.getEventContext();
                if (!ec.isSuspended()) {
                    this.sendResultToTCK("Test1108023Test", false, "SBB onTCKResourceEventX2-ERROR: The event delivery hasn't been suspended, the EventContext.isSuspended() returned false!", 1108023);
                    return;
                }
                ec.resumeDelivery();
                this.setHaveResumedX1(true);
            } else if (activityID.getName().equals("Test1108023Test-ActivityA")) {
                this.tracer.info("Received Test1108023Sbb:I got TCKResourceEventX2 on ActivityA");
                if (!this.getHaveResumedX1()) {
                    this.sendResultToTCK("Test1108023Test", false, "SBB onTCKResourceEventX2-ERROR: The event delivery on ActivityA did not suspend, the event was still delivered from TCKResourceEventX2 on ActivityA", 1108023);
                    return;
                }
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX3);
            EventContext ec = this.getEventContext();
            if (ec != null && ec.isSuspended()) {
                this.sendResultToTCK("Test1108023Test", false, "SBB:onTCKResourceEventX3-ERROR: The event delivery has still been suspended, the EventContext.isSuspended() returned true!", 1108023);
                return;
            }
            this.sendResultToTCK("Test1108023Test", true, "The test of Event delivery can also be manually resumed by an SBB before the timeout period expires using the Event Context\u201a\u00c4\u00f4s resumeDelivery method passed.", 1108023);
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    private void sendResultToTCK(String testName, boolean result, String message, int failedAssertionID) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setTestName(String var1);

    public abstract String getTestName();

    public abstract void setEventContext(EventContext var1);

    public abstract EventContext getEventContext();

    public abstract void setHaveResumedX1(boolean var1);

    public abstract boolean getHaveResumedX1();
}

