/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename.nonselection;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.AbstractConvergenceNameTest;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfileProxyImpl;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class VariableNonSelectionTest
extends AbstractConvergenceNameTest {
    private static final String PROFILE_1 = "PROFILE_1";
    private static final String PROFILE_2 = "PROFILE_2";
    private static final String ADDRESS_PROFILE_TABLE = "tck.AddressAndProfileTestProfile";
    private static final Address ADDRESS_1 = new Address(AddressPlan.IP, "1.0.0.1");
    private static final Address ADDRESS_2 = new Address(AddressPlan.IP, "1.0.0.2");
    private static final Address ADDRESS_3 = new Address(AddressPlan.IP, "1.0.0.3");
    private static final Address ADDRESS_4 = new Address(AddressPlan.IP, "1.0.0.4");
    private static final Address[] ADDRESS_SET_A = new Address[]{ADDRESS_1, ADDRESS_2};
    private static final Address[] ADDRESS_SET_B = new Address[]{ADDRESS_3, ADDRESS_4};
    private ProfileUtils profileUtils;
    private int currentActivityIDSuffix = 0;
    private int currentEventID = 0;
    private boolean profileSwap = false;

    public TCKTestResult run() throws Exception {
        String iesVariable = this.utils().getTestParams().getProperty("fixedIESVariable");
        this.performVariableNonSelectionTest(iesVariable);
        return TCKTestResult.passed();
    }

    private void performVariableNonSelectionTest(String constant) throws Exception {
        this.getLog().info("Performing constant non selection test for selected variable: " + constant);
        TCKActivityID mainActivityID = this.utils().getResourceInterface().createActivity("Activity" + this.currentActivityIDSuffix++);
        this.getLog().info("Created activity: " + mainActivityID.getName());
        InitialEventSelectorParameters iesParams = !constant.equals("CustomName") ? this.createIESParamsForVariable(constant, null) : this.createIESParamsForVariable(constant, "custom_name_A");
        String initialEvent = String.valueOf(this.currentEventID++);
        this.sendEventAndWait("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", initialEvent, mainActivityID, ADDRESS_1, initialEvent, iesParams);
        for (int i = 0; i < this.selected().size(); ++i) {
            String variable = (String)this.selected().get(i);
            if (variable.equals(constant) || variable.equals("CustomName")) continue;
            TCKActivityID activityID = mainActivityID;
            Address address = ADDRESS_1;
            if (this.profileSwap) {
                this.replaceAddressProfile(PROFILE_2, new Address[0]);
                this.replaceAddressProfile(PROFILE_1, ADDRESS_SET_A);
                this.replaceAddressProfile(PROFILE_2, ADDRESS_SET_B);
                this.profileSwap = false;
            }
            String eventType = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1";
            this.getLog().info("Varying variable " + variable);
            if (variable.equals("Address")) {
                address = ADDRESS_2;
            } else if (variable.equals("AddressProfile")) {
                this.replaceAddressProfile(PROFILE_2, new Address[0]);
                this.replaceAddressProfile(PROFILE_1, ADDRESS_SET_B);
                this.replaceAddressProfile(PROFILE_2, ADDRESS_SET_A);
                this.profileSwap = true;
            } else if (variable.equals("ActivityContext")) {
                activityID = this.utils().getResourceInterface().createActivity("Activity" + this.currentActivityIDSuffix++);
            } else if (variable.equals("EventType")) {
                eventType = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2";
            } else if (variable.equals("Event")) {
                // empty if block
            }
            this.sendEventAndWait(eventType, String.valueOf(this.currentEventID++), activityID, address, initialEvent, iesParams);
        }
    }

    private void replaceAddressProfile(String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileUtils.getProfileProvisioningProxy().getProfile(ADDRESS_PROFILE_TABLE, profileName);
        this.setAddressProfile(objectName, addresses);
    }

    private void setAddressProfile(ObjectName objectName, Address[] addresses) throws Exception {
        AddressProfileProxyImpl addressProfileProxy = new AddressProfileProxyImpl(objectName, this.utils().getMBeanFacade());
        addressProfileProxy.editProfile();
        addressProfileProxy.setAddresses(addresses);
        addressProfileProxy.commitProfile();
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileUtils.createStandardAddressProfileTable(ADDRESS_PROFILE_TABLE);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_1, ADDRESS_SET_A);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_2, ADDRESS_SET_B);
        super.setUp();
    }

    private void setupAddressProfile(String tableName, String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileUtils.getProfileProvisioningProxy().createProfile(tableName, profileName);
        this.setAddressProfile(objectName, addresses);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.profileUtils != null) {
            this.profileUtils.getProfileProvisioningProxy().removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_1);
            this.profileUtils.getProfileProvisioningProxy().removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_2);
            this.profileUtils.removeProfileTable(ADDRESS_PROFILE_TABLE);
        }
    }

    private InitialEventSelectorParameters createIESParamsForVariable(String variable, String customName) {
        return new InitialEventSelectorParameters(variable.equals("ActivityContext"), variable.equals("Address"), variable.equals("AddressProfile"), false, variable.equals("EventType"), customName, false, false, false, null);
    }
}

