/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.AbstractMultiVariableSelectionTest;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfileProxyImpl;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class StickyConvergenceNameTest
extends AbstractMultiVariableSelectionTest {
    private static final String PROFILE_1 = "PROFILE_1";
    private static final String ADDRESS_PROFILE_TABLE = "tck.AddressAndProfileTestProfile";
    private static final Address ADDRESS_1 = new Address(AddressPlan.IP, "1.0.0.1");
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProxy;

    public TCKTestResult run() throws Exception {
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("Test2012Activity");
        int eventNumber = 0;
        for (int i = 0; i < this.getCombinations().size(); ++i) {
            String eventID = String.valueOf(eventNumber++);
            Vector variables = (Vector)this.getCombinations().elementAt(i);
            InitialEventSelectorParameters iesParams = this.createIESParamsFromSelected(variables, "Test2012");
            this.getLog().info("Testing combination: " + variables);
            this.sendEventAndWait("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", eventID, activityID, ADDRESS_1, eventID, iesParams);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProxy = this.profileUtils.getProfileProvisioningProxy();
        this.profileUtils.createStandardAddressProfileTable(ADDRESS_PROFILE_TABLE);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_1, new Address[]{ADDRESS_1});
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.profileUtils != null) {
            this.profileProxy.removeProfile(ADDRESS_PROFILE_TABLE, PROFILE_1);
            this.profileUtils.removeProfileTable(ADDRESS_PROFILE_TABLE);
        }
    }

    private void setupAddressProfile(String tableName, String profileName, Address[] addresses) throws Exception {
        ObjectName objectName = this.profileProxy.createProfile(tableName, profileName);
        AddressProfileProxyImpl addressProfileProxy = new AddressProfileProxyImpl(objectName, this.utils().getMBeanFacade());
        addressProfileProxy.editProfile();
        addressProfileProxy.setAddresses(addresses);
        addressProfileProxy.commitProfile();
    }
}

