/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.AbstractConvergenceNameTest;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.InitialEventSelectorParameters;
import java.util.Iterator;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class ConvergenceVariableSelectionTest
extends AbstractConvergenceNameTest {
    private static final String ADDRESS_A = "1.0.0.1";
    private static final String ADDRESS_B = "1.0.0.2";
    private static final String CUSTOM_NAME_A = "CUSTOM_NAME_A";
    private static final String CUSTOM_NAME_B = "CUSTOM_NAME_B";
    private static final String ACTIVITY_NAME_A = "ActivityA";
    private static final String ACTIVITY_NAME_B = "ActivityB";

    public void setUp() throws Exception {
        super.setUp();
        if (this.selected() == null || this.selected().isEmpty()) {
            throw new TCKTestErrorException("At least one convergence name variable must be selected for this test.");
        }
        if (this.selected().contains("AddressProfile")) {
            throw new TCKTestErrorException("The AddressProfile variable is not supported by this test.");
        }
        if (this.selected().contains("Event")) {
            throw new TCKTestErrorException("The Event variable is not supported by this test.");
        }
    }

    public TCKTestResult run() throws Exception {
        String eventID;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String eventType = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1";
        Address address = new Address(AddressPlan.IP, ADDRESS_A);
        TCKActivityID activityID = resource.createActivity(ACTIVITY_NAME_A);
        String customName = CUSTOM_NAME_A;
        int eventNumber = 1;
        String firstEventID = eventID = Integer.toString(eventNumber);
        this.sendEventAndWait(eventType, eventID, activityID, address, eventID, this.createIESParamsFromSelected(customName));
        eventID = Integer.toString(++eventNumber);
        this.sendEventAndWait(eventType, eventID, activityID, address, firstEventID, this.createIESParamsFromSelected(customName));
        Iterator selectedIter = this.selected().iterator();
        while (selectedIter.hasNext()) {
            Object variableToVary = selectedIter.next();
            if ("Address".equals(variableToVary)) {
                address = new Address(AddressPlan.IP, ADDRESS_B);
            }
            if ("EventType".equals(variableToVary)) {
                eventType = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2";
            }
            if ("CustomName".equals(variableToVary)) {
                customName = CUSTOM_NAME_B;
            }
            if ("ActivityContext".equals(variableToVary)) {
                activityID = resource.createActivity(ACTIVITY_NAME_B);
            }
            eventID = Integer.toString(++eventNumber);
            this.sendEventAndWait(eventType, eventID, activityID, address, eventID, this.createIESParamsFromSelected(customName));
        }
        return TCKTestResult.passed();
    }

    private InitialEventSelectorParameters createIESParamsFromSelected(String customName) {
        return new InitialEventSelectorParameters(this.selected().contains("ActivityContext"), this.selected().contains("Address"), false, false, this.selected().contains("EventType"), customName, false, false, false, null);
    }
}

