/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.activities.activitycontext;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;

public class Test587Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final int TEST_ID = 587;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        try {
            this.utils.getLog().fine("Installing and activating service");
            String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
            DeployableUnitID duID = this.utils.install(duPath);
            this.utils.getLog().fine("Service installed.  Now activating.");
            this.utils.activateServices(duID, true);
        }
        catch (TCKTestErrorException e) {
            this.utils.getLog().fine("Exception caught, determining enclosed exception type.");
            if (e.getEnclosedException().getClass().equals(DeploymentException.class)) {
                return TCKTestResult.passed();
            }
            this.utils.getLog().fine("Enclosed exception was not of type DeploymentException.");
            throw e;
        }
        return TCKTestResult.failed(587, "Installation of SBB with invalid Activity Context Interface accessor methods was permitted.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test587Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test587Test.this.result.setPassed();
            } else {
                Test587Test.this.result.setFailed(587, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test587Test.this.utils.getLog().warning("Received exception from SBB");
            Test587Test.this.utils.getLog().warning(e);
            Test587Test.this.result.setError(e);
        }
    }
}

