/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.resource.impl;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;

public class TCKResourceListenerProxy
extends UnicastRemoteObject
implements TCKResourceListener,
Runnable {
    private TCKResourceListener listener;
    private LinkedList messageQueue;
    private volatile boolean isStopping = false;
    private Object listenerLock = new Object();
    private Logable log;

    public TCKResourceListenerProxy(Logable logable) throws RemoteException {
        this.log = logable;
        this.messageQueue = new LinkedList();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSbbMessage(TCKSbbMessage tCKSbbMessage, TCKActivityID tCKActivityID) throws RemoteException {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            if (!this.isStopping) {
                this.messageQueue.addLast(new TCKSbbMessageWrapper(tCKSbbMessage, tCKActivityID));
                this.messageQueue.notifyAll();
            } else {
                this.log.warning("Could not add TCKSbbMessage to queue, as the resource listener proxy is stopping. message=" + tCKSbbMessage + ";calledActivity=" + tCKActivityID);
            }
        }
    }

    public Object onSbbCall(Object object) throws Exception {
        TCKResourceListener tCKResourceListener = this.getListener();
        if (tCKResourceListener != null) {
            return tCKResourceListener.onSbbCall(object);
        }
        this.log.warning("TCKResourceListenerProxy.onSbbCall() called, with no listener set");
        throw new IllegalStateException("TCKResourceListenerProxy.onSbbCall() called, with no listener set");
    }

    public void onActivityCreatedBySbb(TCKActivityID tCKActivityID) throws RemoteException {
        TCKResourceListener tCKResourceListener = this.getListener();
        if (tCKResourceListener != null) {
            tCKResourceListener.onActivityCreatedBySbb(tCKActivityID);
        } else {
            this.log.warning("TCKResourceListenerProxy.onActivityCreatedBySbb() called, with no listener set");
        }
    }

    public void onActivityEndedBySbb(TCKActivityID tCKActivityID) throws RemoteException {
        TCKResourceListener tCKResourceListener = this.getListener();
        if (tCKResourceListener != null) {
            tCKResourceListener.onActivityEndedBySbb(tCKActivityID);
        } else {
            this.log.warning("TCKResourceListenerProxy.onActivityEndedBySbb() called, with no listener set");
        }
    }

    public void onActivityContextInvalid(TCKActivityID tCKActivityID) throws RemoteException {
        TCKResourceListener tCKResourceListener = this.getListener();
        if (tCKResourceListener != null) {
            tCKResourceListener.onActivityContextInvalid(tCKActivityID);
        } else {
            this.log.warning("TCKResourceListenerProxy.onActivityContextInvalid() called, with no listener set");
        }
    }

    public void onException(Exception exception) throws RemoteException {
        TCKResourceListener tCKResourceListener = this.getListener();
        if (tCKResourceListener != null) {
            tCKResourceListener.onException(exception);
        } else {
            this.log.warning("TCKResourceListenerProxy.onException() called, with no listener set");
        }
    }

    public void onEventProcessingSuccessful(long l) throws RemoteException {
        TCKResourceListener tCKResourceListener = this.getListener();
        if (tCKResourceListener != null) {
            tCKResourceListener.onEventProcessingSuccessful(l);
        } else {
            this.log.warning("TCKResourceListenerProxy.onEventProcessingSuccessful() called, with no listener set");
        }
    }

    public void onEventProcessingFailed(long l, String string, Exception exception) throws RemoteException {
        TCKResourceListener tCKResourceListener = this.getListener();
        if (tCKResourceListener != null) {
            tCKResourceListener.onEventProcessingFailed(l, string, exception);
        } else {
            this.log.warning("TCKResourceListenerProxy.onEventProcessingFailed() called, with no listener set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isStopping) {
            TCKSbbMessageWrapper tCKSbbMessageWrapper = null;
            Object object = this.messageQueue;
            synchronized (object) {
                while (this.messageQueue.isEmpty() && !this.isStopping) {
                    try {
                        this.messageQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.isStopping) {
                    return;
                }
                tCKSbbMessageWrapper = (TCKSbbMessageWrapper)this.messageQueue.removeFirst();
            }
            object = tCKSbbMessageWrapper.getMessage();
            TCKActivityID tCKActivityID = tCKSbbMessageWrapper.getCalledActivity();
            Object object2 = this.listenerLock;
            synchronized (object2) {
                if (this.listener != null) {
                    try {
                        this.listener.onSbbMessage((TCKSbbMessage)object, tCKActivityID);
                    }
                    catch (RemoteException remoteException) {
                        this.log.warning("Caught RemoteException when delivering TCKSbbMessage:");
                        this.log.warning(remoteException);
                    }
                    catch (RuntimeException runtimeException) {
                        this.log.warning("Caught RuntimeException when delivering TCKSbbMessage:");
                        this.log.warning(runtimeException);
                    }
                } else {
                    this.log.warning("No listener set to handle message from TCK resource. message=" + object + ";calledActivity=" + tCKActivityID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceListener(TCKResourceListener tCKResourceListener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = tCKResourceListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceListener() {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        Object object = this.messageQueue;
        synchronized (object) {
            this.isStopping = true;
            this.messageQueue.clear();
            this.messageQueue.notifyAll();
        }
        object = this.listenerLock;
        synchronized (object) {
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKResourceListener getListener() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.listener;
        }
    }

    private class TCKSbbMessageWrapper {
        private TCKActivityID calledActivity;
        private TCKSbbMessage message;

        public TCKSbbMessageWrapper(TCKSbbMessage tCKSbbMessage, TCKActivityID tCKActivityID) {
            this.message = tCKSbbMessage;
            this.calledActivity = tCKActivityID;
        }

        public TCKSbbMessage getMessage() {
            return this.message;
        }

        public TCKActivityID getCalledActivity() {
            return this.calledActivity;
        }
    }
}

