/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.resource.adaptor11;

import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityHandleImpl;
import java.util.HashMap;
import javax.slee.facilities.Tracer;

public class TCKActivityMap {
    private int seq = 0;
    private final int vmStart;
    private HashMap handleToActivity = new HashMap();
    private HashMap activityToHandle = new HashMap();
    private final Tracer tracer;

    public TCKActivityMap(Tracer tracer) {
        this.vmStart = (int)System.currentTimeMillis();
        this.tracer = tracer;
    }

    public synchronized TCKActivityHandleImpl allocateActivityHandle(Object object) {
        TCKActivityHandleImpl tCKActivityHandleImpl = (TCKActivityHandleImpl)this.activityToHandle.get(object);
        if (tCKActivityHandleImpl != null) {
            this.tracer.severe("Suspect TCK resource bug, two allocate invocations for the same TCKActivity object");
            return tCKActivityHandleImpl;
        }
        tCKActivityHandleImpl = new TCKActivityHandleImpl(this.vmStart, this.seq++);
        this.handleToActivity.put(tCKActivityHandleImpl, object);
        this.activityToHandle.put(object, tCKActivityHandleImpl);
        return tCKActivityHandleImpl;
    }

    public synchronized void deallocateActivityHandle(TCKActivityHandleImpl tCKActivityHandleImpl) {
        Object v = this.handleToActivity.remove(tCKActivityHandleImpl);
        if (v == null) {
            this.tracer.severe("unknown activity handle: " + tCKActivityHandleImpl);
        } else {
            this.activityToHandle.remove(v);
        }
    }

    public synchronized TCKActivityHandleImpl getActivityHandle(Object object) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("getActivityHandle(): " + object);
        }
        return (TCKActivityHandleImpl)this.activityToHandle.get(object);
    }

    public synchronized boolean isAllocated(Object object) {
        return this.activityToHandle.containsKey(object);
    }

    public synchronized Object getActivity(TCKActivityHandleImpl tCKActivityHandleImpl) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("getActivity(): " + tCKActivityHandleImpl);
        }
        return this.handleToActivity.get(tCKActivityHandleImpl);
    }

    public synchronized void clear() {
        this.handleToActivity.clear();
        this.activityToHandle.clear();
    }
}

