/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.profileutils;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public class BaseMessageSender {
    private RMIObjectChannel out;
    private Logable log;

    public BaseMessageSender(RMIObjectChannel rMIObjectChannel, Logable logable) {
        this.out = rMIObjectChannel;
        this.log = logable;
    }

    public HashMap getBaseConfig() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("MsgClass", new Integer(1));
        return hashMap;
    }

    public void sendException(Exception exception) {
        this.send(exception);
    }

    public void sendFailure(int n, String string, Exception exception) {
        HashMap hashMap = this.getBaseConfig();
        hashMap.put("Type", new Integer(0));
        hashMap.put("ID", new Integer(n));
        if (string != null) {
            hashMap.put("Msg", string);
        }
        if (exception != null) {
            hashMap.put("Cause", exception);
        }
        this.send(hashMap);
    }

    public void sendFailure(int n, String string) {
        this.sendFailure(n, string, null);
    }

    public void sendSuccess(int n, String string) {
        HashMap hashMap = this.getBaseConfig();
        hashMap.put("Type", new Integer(1));
        hashMap.put("ID", new Integer(n));
        if (string != null) {
            hashMap.put("Msg", string);
        }
        this.send(hashMap);
    }

    public void sendError(String string) {
        this.sendError(string, null);
    }

    public void sendError(String string, Exception exception) {
        HashMap hashMap = this.getBaseConfig();
        hashMap.put("Type", new Integer(2));
        if (string != null) {
            hashMap.put("Msg", string);
        }
        if (exception != null) {
            hashMap.put("Cause", exception);
        }
        this.send(hashMap);
    }

    private void send(final Object object) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (BaseMessageSender.this.out == null) {
                    BaseMessageSender.this.log.warning("Attempted to write to the RMIObjectChannel before it was initialized");
                    return null;
                }
                try {
                    BaseMessageSender.this.out.writeObject(object);
                }
                catch (RemoteException remoteException) {
                    BaseMessageSender.this.log.warning("Exception occured when writing to RMIObjectChannel: ");
                    BaseMessageSender.this.log.warning(remoteException);
                }
                return null;
            }
        });
    }

    public void sendLogMsg(String string) {
        HashMap hashMap = this.getBaseConfig();
        hashMap.put("Type", new Integer(3));
        if (string != null) {
            hashMap.put("Msg", string);
        }
        this.send(hashMap);
    }

    public void sendCustomMessage(int n, HashMap hashMap) {
        hashMap.put("Type", new Integer(n));
        this.send(hashMap);
    }
}

