/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.interview;

import com.opencloud.logging.LogLevelUtil;
import com.opencloud.sleetck.lib.interview.EnvironmentInterview;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import javax.slee.facilities.Level;

public class UserOptionsInterview
extends Interview {
    private ChoiceQuestion qDebugLevel = new ChoiceQuestion(this, "debugLevel"){
        {
            int[] nArray = new int[]{11, 3, 1, 14, 15, 16, 17};
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = LogLevelUtil.toString(nArray[i]);
            }
            this.setChoices(stringArray);
            this.setValue(LogLevelUtil.toString(1));
        }

        protected Question getNext() {
            return UserOptionsInterview.this.qSbbTraceLevel;
        }

        public void setValue(String string) {
            int n = LogLevelUtil.toLogLevel(string);
            if (n == 6) {
                throw new IllegalArgumentException("Invalid debug level: " + string);
            }
            super.setValue(LogLevelUtil.toString(n));
        }

        protected void export(Map map) {
            int n = LogLevelUtil.toLogLevel(this.value);
            map.put(UserOptionsInterview.this.parent.envEntry("debugLevel"), Integer.toString(n));
        }
    };
    private ChoiceQuestion qSbbTraceLevel = new ChoiceQuestion(this, "sbbTraceLevel"){
        private Level[] validLevels;
        {
            this.validLevels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST};
            String[] stringArray = new String[this.validLevels.length];
            for (int i = 0; i < this.validLevels.length; ++i) {
                stringArray[i] = this.validLevels[i].toString();
            }
            this.setChoices(stringArray);
            this.setValue(Level.INFO.toString());
        }

        protected Question getNext() {
            return UserOptionsInterview.this.qDefaultTimeout;
        }

        public void setValue(String string) {
            Level level = this.getLevel(string);
            if (level == null) {
                throw new IllegalArgumentException("Invalid Sbb trace level: " + string);
            }
            super.setValue(level.toString());
        }

        protected void export(Map map) {
            String string = null;
            if (this.value != null) {
                Level level = this.getLevel(this.value);
                string = Integer.toString(level.toInt());
            }
            map.put(UserOptionsInterview.this.parent.envEntry("sbbTraceLevel"), string);
        }

        private Level getLevel(String string) {
            Level level = null;
            if (string != null) {
                for (int i = 0; i < this.validLevels.length; ++i) {
                    if (!this.validLevels[i].toString().equalsIgnoreCase(string)) continue;
                    level = this.validLevels[i];
                }
            }
            return level;
        }
    };
    private IntQuestion qDefaultTimeout = new IntQuestion(this, "defaultTimeout"){
        {
            try {
                this.setValue(25000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected Question getNext() {
            return UserOptionsInterview.this.qRestartBetweenTests;
        }

        protected void export(Map map) {
            map.put(UserOptionsInterview.this.parent.envEntry("defaultTimeout"), Integer.toString(this.value));
        }
    };
    private ChoiceQuestion qRestartBetweenTests = new ChoiceQuestion(this, "restartBetweenTests"){
        {
            String[] stringArray = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
            this.setChoices(stringArray);
            this.setValue(Boolean.TRUE.toString());
        }

        protected Question getNext() {
            return UserOptionsInterview.this.qEnd;
        }

        protected void export(Map map) {
            map.put(UserOptionsInterview.this.parent.envEntry("restartBetweenTests"), this.value);
        }
    };
    private FinalQuestion qEnd = new FinalQuestion((Interview)this);
    private EnvironmentInterview parent;

    public UserOptionsInterview(EnvironmentInterview environmentInterview) {
        super((Interview)environmentInterview, "user-options");
        this.parent = environmentInterview;
        this.setFirstQuestion((Question)this.qDebugLevel);
    }
}

