/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra.sleeplugin;

import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventBroadcaster;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventSenderRemoteImpl;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeAgentRemoteImpl;
import com.opencloud.sleetck.lib.infra.sleeplugin.SleeTCKPluginMBean;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.slee.management.SleeProvider;
import javax.slee.management.SleeProviderFactory;

public class SleeTCKPlugin
implements SleeTCKPluginMBean,
MBeanRegistration {
    private int rmiPort;
    private String sleeProviderClass;
    private ObjectName mgmtMBeanName;
    private static boolean _DEBUG_ = true;

    public SleeTCKPlugin(int n, String string) {
        this.rmiPort = n;
        this.sleeProviderClass = string;
    }

    public ObjectName getSleeManagementMBean() {
        return this.mgmtMBeanName;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":name=SleeTCKPlugin");
        }
        SleeProvider sleeProvider = SleeProviderFactory.getSleeProvider((String)this.sleeProviderClass);
        this.mgmtMBeanName = sleeProvider.getSleeManagementMBean();
        if (this.mgmtMBeanName == null) {
            throw new NullPointerException("Provider returned a null ObjectName for the SleeManagementMBean");
        }
        if (_DEBUG_) {
            this.debug("SleeTCKPlugin: Locating registry at port " + this.rmiPort + " on localhost...");
        }
        Registry registry = LocateRegistry.getRegistry(this.rmiPort);
        if (_DEBUG_) {
            this.debug("SleeTCKPlugin: Registry located");
        }
        TCKEventSenderRemoteImpl tCKEventSenderRemoteImpl = new TCKEventSenderRemoteImpl();
        registry.rebind("infra.jmx.TCKEventSender", tCKEventSenderRemoteImpl);
        if (_DEBUG_) {
            this.debug("SleeTCKPlugin: Bound event sender");
        }
        TCKEventBroadcaster tCKEventBroadcaster = new TCKEventBroadcaster();
        tCKEventBroadcaster.setBulkEventHandler(tCKEventSenderRemoteImpl);
        MBeanFacadeAgentRemoteImpl mBeanFacadeAgentRemoteImpl = new MBeanFacadeAgentRemoteImpl();
        mBeanFacadeAgentRemoteImpl.setMBeanServer(mBeanServer);
        mBeanFacadeAgentRemoteImpl.setEventBroadcaster(tCKEventBroadcaster);
        registry.rebind("infra.jmx.MBeanFacadeAgent", mBeanFacadeAgentRemoteImpl);
        if (_DEBUG_) {
            this.debug("SleeTCKPlugin: Bound MBean facade agent");
        }
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    private void debug(String string) {
        System.err.println(string);
    }
}

