/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra.jmx;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.TCKCommunicationException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventListenerRegistry;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeAgentRemote;
import com.opencloud.sleetck.lib.infra.jmx.NotificationListenerID;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class MBeanFacadeImpl
implements MBeanFacade {
    private MBeanFacadeAgentRemote remoteServer;
    private TCKEventListenerRegistry eventListenerRegistry;
    private int nextNotificationListenerID;
    private Map notificationListeners;
    private Logable log;

    public MBeanFacadeImpl(Logable logable) {
        this.log = logable;
        this.nextNotificationListenerID = 1;
        this.notificationListeners = new HashMap();
    }

    public void setMBeanFacadeAgentRemote(MBeanFacadeAgentRemote mBeanFacadeAgentRemote) {
        this.remoteServer = mBeanFacadeAgentRemote;
    }

    public void setListenerRegistry(TCKEventListenerRegistry tCKEventListenerRegistry) {
        this.eventListenerRegistry = tCKEventListenerRegistry;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.createMBean(string, objectName);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.createMBean(string, objectName, objectName2);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.createMBean(string, objectName, objectArray, stringArray);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.createMBean(string, objectName, objectName2, objectArray, stringArray);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            this.remoteServer.unregisterMBean(objectName);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.getObjectInstance(objectName);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.queryMBeans(objectName, queryExp);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.queryNames(objectName, queryExp);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public boolean isRegistered(ObjectName objectName) throws TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.isRegistered(objectName);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public Integer getMBeanCount() throws TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.getMBeanCount();
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.getAttribute(objectName, string);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.getAttributes(objectName, stringArray);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            this.remoteServer.setAttribute(objectName, attribute);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.setAttributes(objectName, attributeList);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            this.log.finest("Invoking the " + string + " operation on " + objectName.toString());
            return this.remoteServer.invoke(objectName, string, objectArray, stringArray);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public String getDefaultDomain() throws TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.getDefaultDomain();
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        if (this.eventListenerRegistry == null) {
            throw new TCKTestErrorException("The event listener registry is not set.");
        }
        NotificationListenerID notificationListenerID = this.createNotificationListenerID();
        NotificationListenerWrapper notificationListenerWrapper = new NotificationListenerWrapper(objectName, notificationListener, object);
        Map map = this.notificationListeners;
        synchronized (map) {
            this.notificationListeners.put(notificationListenerID, notificationListenerWrapper);
        }
        this.eventListenerRegistry.addListener(this, notificationListenerID);
        try {
            this.remoteServer.registerNotificationListener(notificationListenerID, objectName, notificationFilter);
        }
        catch (RemoteException remoteException) {
            this.eventListenerRegistry.removeListener(this, notificationListenerID);
            Map map2 = this.notificationListeners;
            synchronized (map2) {
                this.notificationListeners.remove(notificationListenerID);
            }
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            this.remoteServer.addNotificationListener(objectName, objectName2, notificationFilter, object);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        if (this.eventListenerRegistry == null) {
            throw new TCKTestErrorException("The event listener registry is not set.");
        }
        TCKEventListenerRegistry tCKEventListenerRegistry = this.eventListenerRegistry;
        synchronized (tCKEventListenerRegistry) {
            Map map = this.notificationListeners;
            synchronized (map) {
                for (NotificationListenerID notificationListenerID : new HashSet(this.notificationListeners.keySet())) {
                    NotificationListenerWrapper notificationListenerWrapper = (NotificationListenerWrapper)this.notificationListeners.get(notificationListenerID);
                    if (notificationListenerWrapper == null || !notificationListenerWrapper.getName().equals(objectName) || !notificationListenerWrapper.getListener().equals(notificationListener)) continue;
                    this.deregisterNotificationListener(notificationListenerID, notificationListenerWrapper);
                }
            }
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            this.remoteServer.removeNotificationListener(objectName, objectName2);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.getMBeanInfo(objectName);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, TCKCommunicationException, TCKTestErrorException {
        this.assertConnected();
        try {
            return this.remoteServer.isInstanceOf(objectName, string);
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotificationListeners() throws TCKCommunicationException, TCKTestErrorException {
        RemoteException remoteException = null;
        try {
            this.remoteServer.deregisterAllNotificationListeners();
        }
        catch (RemoteException remoteException2) {
            remoteException = remoteException2;
        }
        this.eventListenerRegistry.removeAllListeners();
        Map map = this.notificationListeners;
        synchronized (map) {
            this.notificationListeners.clear();
        }
        if (remoteException != null) {
            throw new TCKTestErrorException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Object object, Object object2) {
        Map map = this.notificationListeners;
        synchronized (map) {
            NotificationListenerWrapper notificationListenerWrapper = (NotificationListenerWrapper)this.notificationListeners.get(object2);
            if (notificationListenerWrapper != null) {
                notificationListenerWrapper.getListener().handleNotification((Notification)object, notificationListenerWrapper.getHandback());
            }
        }
    }

    private void assertConnected() throws TCKTestErrorException {
        if (this.remoteServer == null) {
            throw new TCKTestErrorException("Not connected to mbean facade remote agent.");
        }
    }

    private synchronized NotificationListenerID createNotificationListenerID() {
        return new NotificationListenerID(this.nextNotificationListenerID++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterNotificationListener(NotificationListenerID notificationListenerID, NotificationListenerWrapper notificationListenerWrapper) throws TCKCommunicationException, TCKTestErrorException, InstanceNotFoundException, ListenerNotFoundException {
        if (this.eventListenerRegistry == null) {
            throw new TCKTestErrorException("The event listener registry is not set.");
        }
        try {
            this.remoteServer.deregisterNotificationListener(notificationListenerID, notificationListenerWrapper.getName());
        }
        catch (RemoteException remoteException) {
            throw new TCKCommunicationException("RemoteException caught while executing remote MBeanServer method", remoteException);
        }
        this.eventListenerRegistry.removeListener(this, notificationListenerID);
        Map map = this.notificationListeners;
        synchronized (map) {
            this.notificationListeners.remove(notificationListenerID);
        }
    }

    private class NotificationListenerWrapper {
        private ObjectName name;
        private NotificationListener listener;
        private Object handback;

        public NotificationListenerWrapper(ObjectName objectName, NotificationListener notificationListener, Object object) {
            this.name = objectName;
            this.listener = notificationListener;
            this.handback = object;
        }

        private ObjectName getName() {
            return this.name;
        }

        private NotificationListener getListener() {
            return this.listener;
        }

        private Object getHandback() {
            return this.handback;
        }
    }
}

