/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib;

import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.testutils.ExceptionsUtil;
import java.io.Serializable;

public class TCKTestResult
implements Serializable {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NO_ASSERTION = -1;
    private int type;
    private String reason;
    private int assertionID;

    private TCKTestResult(int n, String string) {
        this(n, string, -1);
    }

    private TCKTestResult(int n, String string, int n2) {
        this.type = n;
        this.reason = string;
        this.assertionID = n2;
    }

    public static TCKTestResult passed() {
        return new TCKTestResult(0, null);
    }

    public static TCKTestResult failed(int n, String string) {
        return new TCKTestResult(1, string, n);
    }

    public static TCKTestResult failed(TCKTestFailureException tCKTestFailureException) {
        return TCKTestResult.failed(tCKTestFailureException.getAssertionID(), ExceptionsUtil.formatThrowable(tCKTestFailureException));
    }

    public static TCKTestResult error(String string) {
        return TCKTestResult.error(string, null);
    }

    public static TCKTestResult error(Throwable throwable) {
        return TCKTestResult.error(null, throwable);
    }

    public static TCKTestResult error(String string, Throwable throwable) {
        String string2 = throwable == null ? null : ExceptionsUtil.formatThrowable(throwable);
        String string3 = null;
        string3 = string == null ? string2 : (throwable == null ? string : string + "\nCause:" + string2);
        return new TCKTestResult(2, string3);
    }

    public boolean isPassed() {
        return this.type == 0;
    }

    public boolean isFailed() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public int getAssertionID() {
        return this.assertionID;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(TCKTestResult.typeToString(this.type));
        if (!this.isPassed()) {
            stringBuffer.append("\nReason: ").append(this.reason);
        }
        if (this.isFailed()) {
            stringBuffer.append("\nAssertion ID: ").append(this.assertionID);
        }
        return stringBuffer.toString();
    }

    public static String typeToString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "PASSED";
                break;
            }
            case 1: {
                string = "FAILED";
                break;
            }
            case 2: {
                string = "ERROR";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized result type: " + n);
            }
        }
        return string;
    }

    public synchronized Object toExported() {
        Object[] objectArray = new Object[]{new Integer(this.type), this.reason, new Integer(this.assertionID)};
        return objectArray;
    }

    public static TCKTestResult fromExported(Object object) {
        Object[] objectArray = (Object[])object;
        int n = (Integer)objectArray[0];
        String string = (String)objectArray[1];
        int n2 = (Integer)objectArray[2];
        return new TCKTestResult(n, string, n2);
    }
}

