/*
 * Decompiled with CFR 0.152.
 */
package com.openai.core;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.azure.AzureUrlCategory;
import com.openai.azure.AzureUrlPathMode;
import com.openai.azure.credential.AzureApiKeyCredential;
import com.openai.core.Check;
import com.openai.core.DefaultSleeper;
import com.openai.core.ObjectMappers;
import com.openai.core.PhantomReachableExecutorService;
import com.openai.core.PhantomReachableSleeper;
import com.openai.core.Properties;
import com.openai.core.Sleeper;
import com.openai.core.Timeout;
import com.openai.core.http.Headers;
import com.openai.core.http.HttpClient;
import com.openai.core.http.PhantomReachableClosingHttpClient;
import com.openai.core.http.QueryParams;
import com.openai.core.http.RetryingHttpClient;
import com.openai.credential.BearerTokenCredential;
import com.openai.credential.Credential;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u000267B\u00a9\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0006\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\b\u0010 \u001a\u0004\u0018\u00010\u0010\u0012\b\u0010!\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\"\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010#J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u00101\u001a\u000202J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001003J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001003J\u0006\u00104\u001a\u000205J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001003R\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u001d8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010$R\u0013\u0010\u001e\u001a\u00020\u001f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010%R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010&R\u0013\u0010\r\u001a\u00020\u000e8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010'R\u0013\u0010\u001a\u001a\u00020\u001b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010(R\u0013\u0010\u0011\u001a\u00020\u00128\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010)R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010*R\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010+R\u0013\u0010\u0018\u001a\u00020\u00198\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010,R\u0010\u0010 \u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00020\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010-R\u0013\u0010\u0015\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010&R\u0013\u0010\u000b\u001a\u00020\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010.R\u0013\u0010\t\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010/R\u0013\u0010\u0016\u001a\u00020\u00178\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u00100R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/openai/core/ClientOptions;", "", "originalHttpClient", "Lcom/openai/core/http/HttpClient;", "httpClient", "checkJacksonVersionCompatibility", "", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "streamHandlerExecutor", "Ljava/util/concurrent/Executor;", "sleeper", "Lcom/openai/core/Sleeper;", "clock", "Ljava/time/Clock;", "baseUrl", "", "headers", "Lcom/openai/core/http/Headers;", "queryParams", "Lcom/openai/core/http/QueryParams;", "responseValidation", "timeout", "Lcom/openai/core/Timeout;", "maxRetries", "", "credential", "Lcom/openai/credential/Credential;", "azureServiceVersion", "Lcom/openai/azure/AzureOpenAIServiceVersion;", "azureUrlPathMode", "Lcom/openai/azure/AzureUrlPathMode;", "organization", "project", "webhookSecret", "(Lcom/openai/core/http/HttpClient;Lcom/openai/core/http/HttpClient;ZLcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/util/concurrent/Executor;Lcom/openai/core/Sleeper;Ljava/time/Clock;Ljava/lang/String;Lcom/openai/core/http/Headers;Lcom/openai/core/http/QueryParams;ZLcom/openai/core/Timeout;ILcom/openai/credential/Credential;Lcom/openai/azure/AzureOpenAIServiceVersion;Lcom/openai/azure/AzureUrlPathMode;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "()Lcom/openai/azure/AzureOpenAIServiceVersion;", "()Lcom/openai/azure/AzureUrlPathMode;", "()Z", "()Ljava/time/Clock;", "()Lcom/openai/credential/Credential;", "()Lcom/openai/core/http/Headers;", "()Lcom/openai/core/http/HttpClient;", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "()I", "()Lcom/openai/core/http/QueryParams;", "()Lcom/openai/core/Sleeper;", "()Ljava/util/concurrent/Executor;", "()Lcom/openai/core/Timeout;", "close", "", "Ljava/util/Optional;", "toBuilder", "Lcom/openai/core/ClientOptions$Builder;", "Builder", "Companion", "openai-java-core"})
public final class ClientOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient originalHttpClient;
    @NotNull
    private final HttpClient httpClient;
    private final boolean checkJacksonVersionCompatibility;
    @NotNull
    private final JsonMapper jsonMapper;
    @NotNull
    private final Executor streamHandlerExecutor;
    @NotNull
    private final Sleeper sleeper;
    @NotNull
    private final Clock clock;
    @Nullable
    private final String baseUrl;
    @NotNull
    private final Headers headers;
    @NotNull
    private final QueryParams queryParams;
    private final boolean responseValidation;
    @NotNull
    private final Timeout timeout;
    private final int maxRetries;
    @NotNull
    private final Credential credential;
    @Nullable
    private final AzureOpenAIServiceVersion azureServiceVersion;
    @NotNull
    private final AzureUrlPathMode azureUrlPathMode;
    @Nullable
    private final String organization;
    @Nullable
    private final String project;
    @Nullable
    private final String webhookSecret;
    @NotNull
    public static final String PRODUCTION_URL = "https://api.openai.com/v1";

    private ClientOptions(HttpClient originalHttpClient, HttpClient httpClient, boolean checkJacksonVersionCompatibility2, JsonMapper jsonMapper, Executor streamHandlerExecutor2, Sleeper sleeper, Clock clock, String baseUrl, Headers headers, QueryParams queryParams, boolean responseValidation, Timeout timeout, int maxRetries, Credential credential, AzureOpenAIServiceVersion azureServiceVersion, AzureUrlPathMode azureUrlPathMode, String organization, String project, String webhookSecret) {
        this.originalHttpClient = originalHttpClient;
        this.httpClient = httpClient;
        this.checkJacksonVersionCompatibility = checkJacksonVersionCompatibility2;
        this.jsonMapper = jsonMapper;
        this.streamHandlerExecutor = streamHandlerExecutor2;
        this.sleeper = sleeper;
        this.clock = clock;
        this.baseUrl = baseUrl;
        this.headers = headers;
        this.queryParams = queryParams;
        this.responseValidation = responseValidation;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.credential = credential;
        this.azureServiceVersion = azureServiceVersion;
        this.azureUrlPathMode = azureUrlPathMode;
        this.organization = organization;
        this.project = project;
        this.webhookSecret = webhookSecret;
        if (this.checkJacksonVersionCompatibility) {
            Check.checkJacksonVersionCompatibility();
        }
    }

    @JvmName(name="httpClient")
    @NotNull
    public final HttpClient httpClient() {
        return this.httpClient;
    }

    @JvmName(name="checkJacksonVersionCompatibility")
    public final boolean checkJacksonVersionCompatibility() {
        return this.checkJacksonVersionCompatibility;
    }

    @JvmName(name="jsonMapper")
    @NotNull
    public final JsonMapper jsonMapper() {
        return this.jsonMapper;
    }

    @JvmName(name="streamHandlerExecutor")
    @NotNull
    public final Executor streamHandlerExecutor() {
        return this.streamHandlerExecutor;
    }

    @JvmName(name="sleeper")
    @NotNull
    public final Sleeper sleeper() {
        return this.sleeper;
    }

    @JvmName(name="clock")
    @NotNull
    public final Clock clock() {
        return this.clock;
    }

    @JvmName(name="headers")
    @NotNull
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="queryParams")
    @NotNull
    public final QueryParams queryParams() {
        return this.queryParams;
    }

    @JvmName(name="responseValidation")
    public final boolean responseValidation() {
        return this.responseValidation;
    }

    @JvmName(name="timeout")
    @NotNull
    public final Timeout timeout() {
        return this.timeout;
    }

    @JvmName(name="maxRetries")
    public final int maxRetries() {
        return this.maxRetries;
    }

    @JvmName(name="credential")
    @NotNull
    public final Credential credential() {
        return this.credential;
    }

    @JvmName(name="azureServiceVersion")
    @Nullable
    public final AzureOpenAIServiceVersion azureServiceVersion() {
        return this.azureServiceVersion;
    }

    @JvmName(name="azureUrlPathMode")
    @NotNull
    public final AzureUrlPathMode azureUrlPathMode() {
        return this.azureUrlPathMode;
    }

    @NotNull
    public final String baseUrl() {
        String string = this.baseUrl;
        if (string == null) {
            string = PRODUCTION_URL;
        }
        return string;
    }

    @NotNull
    public final Optional<String> organization() {
        Optional<String> optional = Optional.ofNullable(this.organization);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(organization)");
        return optional;
    }

    @NotNull
    public final Optional<String> project() {
        Optional<String> optional = Optional.ofNullable(this.project);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(project)");
        return optional;
    }

    @NotNull
    public final Optional<String> webhookSecret() {
        Optional<String> optional = Optional.ofNullable(this.webhookSecret);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(webhookSecret)");
        return optional;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$openai_java_core(this);
    }

    public final void close() {
        this.httpClient.close();
        Executor executor = this.streamHandlerExecutor;
        ExecutorService executorService = executor instanceof ExecutorService ? (ExecutorService)executor : null;
        if (executorService != null) {
            executorService.shutdown();
        }
        this.sleeper.close();
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final ClientOptions fromEnv() {
        return Companion.fromEnv();
    }

    public /* synthetic */ ClientOptions(HttpClient originalHttpClient, HttpClient httpClient, boolean checkJacksonVersionCompatibility2, JsonMapper jsonMapper, Executor streamHandlerExecutor2, Sleeper sleeper, Clock clock, String baseUrl, Headers headers, QueryParams queryParams, boolean responseValidation, Timeout timeout, int maxRetries, Credential credential, AzureOpenAIServiceVersion azureServiceVersion, AzureUrlPathMode azureUrlPathMode, String organization, String project, String webhookSecret, DefaultConstructorMarker $constructor_marker) {
        this(originalHttpClient, httpClient, checkJacksonVersionCompatibility2, jsonMapper, streamHandlerExecutor2, sleeper, clock, baseUrl, headers, queryParams, responseValidation, timeout, maxRetries, credential, azureServiceVersion, azureUrlPathMode, organization, project, webhookSecret);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0$J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0006\u0010%\u001a\u00020&J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020&H\u0000\u00a2\u0006\u0002\b)J\u0006\u0010*\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020+J \u0010\u000f\u001a\u00020\u00002\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0-0,J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0$J\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\bJ\u0014\u0010\u0018\u001a\u00020\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0$J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\bJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020+J \u0010.\u001a\u00020\u00002\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0-0,J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u000200J \u0010/\u001a\u00020\u00002\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0-0,J\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\bJ\u001c\u00104\u001a\u00020\u00002\u0006\u00102\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\b0-J\u0016\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\b2\u0006\u00103\u001a\u00020\bJ\u001c\u00108\u001a\u00020\u00002\u0006\u00107\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\b0-J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u000200J \u0010\u0019\u001a\u00020\u00002\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0-0,J\u0014\u00109\u001a\u00020\u00002\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\b0;J\u0014\u0010<\u001a\u00020\u00002\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0;J\u000e\u0010>\u001a\u00020\u00002\u0006\u00102\u001a\u00020\bJ\u000e\u0010?\u001a\u00020\u00002\u0006\u00107\u001a\u00020\bJ\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020+J \u0010@\u001a\u00020\u00002\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0-0,J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u000200J \u0010A\u001a\u00020\u00002\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0-0,J\u0016\u0010B\u001a\u00020\u00002\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\bJ\u001c\u0010B\u001a\u00020\u00002\u0006\u00102\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\b0-J\u0016\u0010C\u001a\u00020\u00002\u0006\u00107\u001a\u00020\b2\u0006\u00103\u001a\u00020\bJ\u001c\u0010C\u001a\u00020\u00002\u0006\u00107\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\b0-J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020DJ\u0014\u0010\"\u001a\u00020\u00002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0$J\u0010\u0010\"\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/openai/core/ClientOptions$Builder;", "", "()V", "azureServiceVersion", "Lcom/openai/azure/AzureOpenAIServiceVersion;", "azureUrlPathMode", "Lcom/openai/azure/AzureUrlPathMode;", "baseUrl", "", "checkJacksonVersionCompatibility", "", "clock", "Ljava/time/Clock;", "credential", "Lcom/openai/credential/Credential;", "headers", "Lcom/openai/core/http/Headers$Builder;", "httpClient", "Lcom/openai/core/http/HttpClient;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "maxRetries", "", "organization", "project", "queryParams", "Lcom/openai/core/http/QueryParams$Builder;", "responseValidation", "sleeper", "Lcom/openai/core/Sleeper;", "streamHandlerExecutor", "Ljava/util/concurrent/Executor;", "timeout", "Lcom/openai/core/Timeout;", "webhookSecret", "apiKey", "Ljava/util/Optional;", "build", "Lcom/openai/core/ClientOptions;", "from", "clientOptions", "from$openai_java_core", "fromEnv", "Lcom/openai/core/http/Headers;", "", "", "putAllHeaders", "putAllQueryParams", "Lcom/openai/core/http/QueryParams;", "putHeader", "name", "value", "putHeaders", "values", "putQueryParam", "key", "putQueryParams", "removeAllHeaders", "names", "", "removeAllQueryParams", "keys", "removeHeaders", "removeQueryParams", "replaceAllHeaders", "replaceAllQueryParams", "replaceHeaders", "replaceQueryParams", "Ljava/time/Duration;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nClientOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientOptions.kt\ncom/openai/core/ClientOptions$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,616:1\n1#2:617\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpClient httpClient;
        private boolean checkJacksonVersionCompatibility = true;
        @NotNull
        private JsonMapper jsonMapper = ObjectMappers.jsonMapper();
        @Nullable
        private Executor streamHandlerExecutor;
        @Nullable
        private Sleeper sleeper;
        @NotNull
        private Clock clock;
        @Nullable
        private String baseUrl;
        @NotNull
        private Headers.Builder headers;
        @NotNull
        private QueryParams.Builder queryParams;
        private boolean responseValidation;
        @NotNull
        private Timeout timeout;
        private int maxRetries;
        @Nullable
        private Credential credential;
        @Nullable
        private AzureOpenAIServiceVersion azureServiceVersion;
        @NotNull
        private AzureUrlPathMode azureUrlPathMode;
        @Nullable
        private String organization;
        @Nullable
        private String project;
        @Nullable
        private String webhookSecret;

        public Builder() {
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC()");
            this.clock = clock;
            this.headers = Headers.Companion.builder();
            this.queryParams = QueryParams.Companion.builder();
            this.timeout = Timeout.Companion.default();
            this.maxRetries = 2;
            this.azureUrlPathMode = AzureUrlPathMode.AUTO;
        }

        public final /* synthetic */ Builder from$openai_java_core(ClientOptions clientOptions) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.httpClient = clientOptions.originalHttpClient;
            $this$from_u24lambda_u240.checkJacksonVersionCompatibility = clientOptions.checkJacksonVersionCompatibility();
            $this$from_u24lambda_u240.jsonMapper = clientOptions.jsonMapper();
            $this$from_u24lambda_u240.streamHandlerExecutor = clientOptions.streamHandlerExecutor();
            $this$from_u24lambda_u240.sleeper = clientOptions.sleeper();
            $this$from_u24lambda_u240.clock = clientOptions.clock();
            $this$from_u24lambda_u240.baseUrl = clientOptions.baseUrl;
            $this$from_u24lambda_u240.headers = clientOptions.headers().toBuilder();
            $this$from_u24lambda_u240.queryParams = clientOptions.queryParams().toBuilder();
            $this$from_u24lambda_u240.responseValidation = clientOptions.responseValidation();
            $this$from_u24lambda_u240.timeout = clientOptions.timeout();
            $this$from_u24lambda_u240.maxRetries = clientOptions.maxRetries();
            $this$from_u24lambda_u240.credential = clientOptions.credential();
            $this$from_u24lambda_u240.azureServiceVersion = clientOptions.azureServiceVersion();
            $this$from_u24lambda_u240.azureUrlPathMode = clientOptions.azureUrlPathMode();
            $this$from_u24lambda_u240.organization = clientOptions.organization;
            $this$from_u24lambda_u240.project = clientOptions.project;
            $this$from_u24lambda_u240.webhookSecret = clientOptions.webhookSecret;
            return builder;
        }

        @NotNull
        public final Builder httpClient(@NotNull HttpClient httpClient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Builder $this$httpClient_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u241.httpClient = new PhantomReachableClosingHttpClient(httpClient);
            return builder;
        }

        @NotNull
        public final Builder checkJacksonVersionCompatibility(boolean checkJacksonVersionCompatibility2) {
            Builder builder;
            Builder $this$checkJacksonVersionCompatibility_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$checkJacksonVersionCompatibility_u24lambda_u242.checkJacksonVersionCompatibility = checkJacksonVersionCompatibility2;
            return builder;
        }

        @NotNull
        public final Builder jsonMapper(@NotNull JsonMapper jsonMapper) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
            Builder $this$jsonMapper_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$jsonMapper_u24lambda_u243.jsonMapper = jsonMapper;
            return builder;
        }

        @NotNull
        public final Builder streamHandlerExecutor(@NotNull Executor streamHandlerExecutor2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)streamHandlerExecutor2, (String)"streamHandlerExecutor");
            Builder $this$streamHandlerExecutor_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$streamHandlerExecutor_u24lambda_u244.streamHandlerExecutor = streamHandlerExecutor2 instanceof ExecutorService ? (Executor)new PhantomReachableExecutorService((ExecutorService)streamHandlerExecutor2) : streamHandlerExecutor2;
            return builder;
        }

        @NotNull
        public final Builder sleeper(@NotNull Sleeper sleeper) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)sleeper, (String)"sleeper");
            Builder $this$sleeper_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$sleeper_u24lambda_u245.sleeper = new PhantomReachableSleeper(sleeper);
            return builder;
        }

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Builder $this$clock_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$clock_u24lambda_u246.clock = clock;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@Nullable String baseUrl) {
            Builder builder;
            Builder $this$baseUrl_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u247.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull Optional<String> baseUrl) {
            Intrinsics.checkNotNullParameter(baseUrl, (String)"baseUrl");
            return this.baseUrl((String)OptionalsKt.getOrNull(baseUrl));
        }

        @NotNull
        public final Builder responseValidation(boolean responseValidation) {
            Builder builder;
            Builder $this$responseValidation_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$responseValidation_u24lambda_u248.responseValidation = responseValidation;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Timeout timeout) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            Builder $this$timeout_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$timeout_u24lambda_u249.timeout = timeout;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Duration timeout) {
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            return this.timeout(Timeout.Companion.builder().request(timeout).build());
        }

        @NotNull
        public final Builder maxRetries(int maxRetries) {
            Builder builder;
            Builder $this$maxRetries_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$maxRetries_u24lambda_u2410.maxRetries = maxRetries;
            return builder;
        }

        @NotNull
        public final Builder apiKey(@NotNull String apiKey) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Builder $this$apiKey_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$apiKey_u24lambda_u2411.credential = BearerTokenCredential.Companion.create(apiKey);
            return builder;
        }

        @NotNull
        public final Builder credential(@NotNull Credential credential) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
            Builder $this$credential_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$credential_u24lambda_u2412.credential = credential;
            return builder;
        }

        @NotNull
        public final Builder azureServiceVersion(@NotNull AzureOpenAIServiceVersion azureServiceVersion) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)azureServiceVersion, (String)"azureServiceVersion");
            Builder $this$azureServiceVersion_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$azureServiceVersion_u24lambda_u2413.azureServiceVersion = azureServiceVersion;
            return builder;
        }

        @NotNull
        public final Builder azureUrlPathMode(@NotNull AzureUrlPathMode azureUrlPathMode) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)azureUrlPathMode), (String)"azureUrlPathMode");
            Builder $this$azureUrlPathMode_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$azureUrlPathMode_u24lambda_u2414.azureUrlPathMode = azureUrlPathMode;
            return builder;
        }

        @NotNull
        public final Builder organization(@Nullable String organization) {
            Builder builder;
            Builder $this$organization_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$organization_u24lambda_u2415.organization = organization;
            return builder;
        }

        @NotNull
        public final Builder organization(@NotNull Optional<String> organization) {
            Intrinsics.checkNotNullParameter(organization, (String)"organization");
            return this.organization((String)OptionalsKt.getOrNull(organization));
        }

        @NotNull
        public final Builder project(@Nullable String project) {
            Builder builder;
            Builder $this$project_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$project_u24lambda_u2416.project = project;
            return builder;
        }

        @NotNull
        public final Builder project(@NotNull Optional<String> project) {
            Intrinsics.checkNotNullParameter(project, (String)"project");
            return this.project((String)OptionalsKt.getOrNull(project));
        }

        @NotNull
        public final Builder webhookSecret(@Nullable String webhookSecret) {
            Builder builder;
            Builder $this$webhookSecret_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$webhookSecret_u24lambda_u2417.webhookSecret = webhookSecret;
            return builder;
        }

        @NotNull
        public final Builder webhookSecret(@NotNull Optional<String> webhookSecret) {
            Intrinsics.checkNotNullParameter(webhookSecret, (String)"webhookSecret");
            return this.webhookSecret((String)OptionalsKt.getOrNull(webhookSecret));
        }

        @NotNull
        public final Builder headers(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$headers_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2418.headers.clear();
            $this$headers_u24lambda_u2418.putAllHeaders(headers);
            return builder;
        }

        @NotNull
        public final Builder headers(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$headers_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2419.headers.clear();
            $this$headers_u24lambda_u2419.putAllHeaders(headers);
            return builder;
        }

        @NotNull
        public final Builder putHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putHeader_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$putHeader_u24lambda_u2420.headers.put(name, value);
            return builder;
        }

        @NotNull
        public final Builder putHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putHeaders_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$putHeaders_u24lambda_u2421.headers.put(name, values);
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$putAllHeaders_u24lambda_u2422.headers.putAll(headers);
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$putAllHeaders_u24lambda_u2423.headers.putAll(headers);
            return builder;
        }

        @NotNull
        public final Builder replaceHeaders(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceHeaders_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$replaceHeaders_u24lambda_u2424.headers.replace(name, value);
            return builder;
        }

        @NotNull
        public final Builder replaceHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceHeaders_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$replaceHeaders_u24lambda_u2425.headers.replace(name, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllHeaders(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$replaceAllHeaders_u24lambda_u2426 = builder = this;
            boolean bl = false;
            $this$replaceAllHeaders_u24lambda_u2426.headers.replaceAll(headers);
            return builder;
        }

        @NotNull
        public final Builder replaceAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$replaceAllHeaders_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$replaceAllHeaders_u24lambda_u2427.headers.replaceAll(headers);
            return builder;
        }

        @NotNull
        public final Builder removeHeaders(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeHeaders_u24lambda_u2428 = builder = this;
            boolean bl = false;
            $this$removeHeaders_u24lambda_u2428.headers.remove(name);
            return builder;
        }

        @NotNull
        public final Builder removeAllHeaders(@NotNull Set<String> names) {
            Builder builder;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Builder $this$removeAllHeaders_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$removeAllHeaders_u24lambda_u2429.headers.removeAll(names);
            return builder;
        }

        @NotNull
        public final Builder queryParams(@NotNull QueryParams queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryParams, (String)"queryParams");
            Builder $this$queryParams_u24lambda_u2430 = builder = this;
            boolean bl = false;
            $this$queryParams_u24lambda_u2430.queryParams.clear();
            $this$queryParams_u24lambda_u2430.putAllQueryParams(queryParams);
            return builder;
        }

        @NotNull
        public final Builder queryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$queryParams_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$queryParams_u24lambda_u2431.queryParams.clear();
            $this$queryParams_u24lambda_u2431.putAllQueryParams(queryParams);
            return builder;
        }

        @NotNull
        public final Builder putQueryParam(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putQueryParam_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$putQueryParam_u24lambda_u2432.queryParams.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putQueryParams_u24lambda_u2433 = builder = this;
            boolean bl = false;
            $this$putQueryParams_u24lambda_u2433.queryParams.put(key, values);
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull QueryParams queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u2434 = builder = this;
            boolean bl = false;
            $this$putAllQueryParams_u24lambda_u2434.queryParams.putAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u2435 = builder = this;
            boolean bl = false;
            $this$putAllQueryParams_u24lambda_u2435.queryParams.putAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceQueryParams(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceQueryParams_u24lambda_u2436 = builder = this;
            boolean bl = false;
            $this$replaceQueryParams_u24lambda_u2436.queryParams.replace(key, value);
            return builder;
        }

        @NotNull
        public final Builder replaceQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceQueryParams_u24lambda_u2437 = builder = this;
            boolean bl = false;
            $this$replaceQueryParams_u24lambda_u2437.queryParams.replace(key, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllQueryParams(@NotNull QueryParams queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryParams, (String)"queryParams");
            Builder $this$replaceAllQueryParams_u24lambda_u2438 = builder = this;
            boolean bl = false;
            $this$replaceAllQueryParams_u24lambda_u2438.queryParams.replaceAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$replaceAllQueryParams_u24lambda_u2439 = builder = this;
            boolean bl = false;
            $this$replaceAllQueryParams_u24lambda_u2439.queryParams.replaceAll(queryParams);
            return builder;
        }

        @NotNull
        public final Builder removeQueryParams(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeQueryParams_u24lambda_u2440 = builder = this;
            boolean bl = false;
            $this$removeQueryParams_u24lambda_u2440.queryParams.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllQueryParams(@NotNull Set<String> keys2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys2, (String)"keys");
            Builder $this$removeAllQueryParams_u24lambda_u2441 = builder = this;
            boolean bl = false;
            $this$removeAllQueryParams_u24lambda_u2441.queryParams.removeAll(keys2);
            return builder;
        }

        @NotNull
        public final Timeout timeout() {
            return this.timeout;
        }

        @NotNull
        public final Builder fromEnv() {
            String openAIWebhookSecret;
            CharSequence charSequence;
            String string;
            String openAIOrgId;
            String string2;
            String openAIKey;
            String string3;
            String string4;
            Builder builder;
            Builder $this$fromEnv_u24lambda_u2443 = builder = this;
            boolean bl = false;
            String string5 = System.getProperty("openai.baseUrl");
            if (string5 == null) {
                string5 = System.getenv("OPENAI_BASE_URL");
            }
            String string6 = string4 = string5;
            if (string6 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"System.getProperty(\"open\u2026getenv(\"OPENAI_BASE_URL\")");
                String it = string4;
                boolean bl2 = false;
                $this$fromEnv_u24lambda_u2443.baseUrl(it);
            }
            if ((string3 = System.getProperty("openai.apiKey")) == null) {
                string3 = openAIKey = System.getenv("OPENAI_API_KEY");
            }
            if ((string2 = System.getProperty("openai.orgId")) == null) {
                string2 = openAIOrgId = System.getenv("OPENAI_ORG_ID");
            }
            if ((string = System.getProperty("openai.projectId")) == null) {
                string = System.getenv("OPENAI_PROJECT_ID");
            }
            String openAIProjectId = string;
            String azureOpenAIKey = System.getenv("AZURE_OPENAI_KEY");
            String string7 = System.getProperty("openai.webhookSecret");
            if (string7 == null) {
                string7 = System.getenv("OPENAI_WEBHOOK_SECRET");
            }
            if (!((charSequence = (CharSequence)(openAIWebhookSecret = string7)) == null || charSequence.length() == 0)) {
                $this$fromEnv_u24lambda_u2443.webhookSecret(openAIWebhookSecret);
            }
            charSequence = openAIKey;
            if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)azureOpenAIKey) == null || charSequence.length() == 0)) {
                throw new IllegalArgumentException("Both OpenAI and Azure OpenAI API keys, `OPENAI_API_KEY` and `AZURE_OPENAI_KEY`, are set. Please specify only one");
            }
            charSequence = openAIKey;
            if (!(charSequence == null || charSequence.length() == 0)) {
                Intrinsics.checkNotNullExpressionValue((Object)openAIKey, (String)"openAIKey");
                $this$fromEnv_u24lambda_u2443.credential(BearerTokenCredential.Companion.create(openAIKey));
                $this$fromEnv_u24lambda_u2443.organization(openAIOrgId);
                $this$fromEnv_u24lambda_u2443.project(openAIProjectId);
            } else {
                charSequence = azureOpenAIKey;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    Intrinsics.checkNotNullExpressionValue((Object)azureOpenAIKey, (String)"azureOpenAIKey");
                    $this$fromEnv_u24lambda_u2443.credential(AzureApiKeyCredential.Companion.create(azureOpenAIKey));
                }
            }
            return builder;
        }

        @NotNull
        public final ClientOptions build() {
            String it;
            Sleeper sleeper;
            Executor streamHandlerExecutor2;
            HttpClient httpClient = Check.checkRequired("httpClient", this.httpClient);
            Executor executor = this.streamHandlerExecutor;
            if (executor == null) {
                ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){
                    @NotNull
                    private final ThreadFactory threadFactory;
                    @NotNull
                    private final AtomicLong count;
                    {
                        ThreadFactory threadFactory = Executors.defaultThreadFactory();
                        Intrinsics.checkNotNullExpressionValue((Object)threadFactory, (String)"defaultThreadFactory()");
                        this.threadFactory = threadFactory;
                        this.count = new AtomicLong(0L);
                    }

                    @NotNull
                    public Thread newThread(@NotNull Runnable runnable) {
                        Thread thread;
                        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                        Thread it = thread = this.threadFactory.newThread(runnable);
                        boolean bl = false;
                        it.setName("openai-stream-handler-thread-" + this.count.getAndIncrement());
                        Thread thread2 = thread;
                        Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"threadFactory.newThread(\u2026                        }");
                        return thread2;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(\n   \u2026                        )");
                executor = streamHandlerExecutor2 = (Executor)new PhantomReachableExecutorService(executorService);
            }
            if ((sleeper = this.sleeper) == null) {
                sleeper = new PhantomReachableSleeper(new DefaultSleeper());
            }
            Sleeper sleeper2 = sleeper;
            Credential credential = Check.checkRequired("credential", this.credential);
            Headers.Builder headers = Headers.Companion.builder();
            QueryParams.Builder queryParams = QueryParams.Companion.builder();
            headers.put("X-Stainless-Lang", "java");
            headers.put("X-Stainless-Arch", Properties.getOsArch());
            headers.put("X-Stainless-OS", Properties.getOsName());
            headers.put("X-Stainless-OS-Version", Properties.getOsVersion());
            headers.put("X-Stainless-Package-Version", Properties.getPackageVersion());
            headers.put("X-Stainless-Runtime", "JRE");
            headers.put("X-Stainless-Runtime-Version", Properties.getJavaVersion());
            String string = this.organization;
            if (string != null) {
                it = string;
                boolean bl = false;
                headers.put("OpenAI-Organization", it);
            }
            String string2 = this.project;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                headers.put("OpenAI-Project", it);
            }
            headers.replaceAll(this.headers.build());
            Credential credential2 = credential;
            if (credential2 instanceof AzureApiKeyCredential) {
                headers.replace("api-key", ((AzureApiKeyCredential)credential).apiKey());
            } else if (credential2 instanceof BearerTokenCredential) {
                headers.replace("Authorization", "Bearer " + ((BearerTokenCredential)credential).token());
            } else {
                throw new IllegalArgumentException("Invalid credential type");
            }
            String string3 = this.baseUrl;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[AzureUrlCategory.Companion.categorizeBaseUrl(it, this.azureUrlPathMode).ordinal()]) {
                    case 1: {
                        AzureOpenAIServiceVersion azureOpenAIServiceVersion = this.azureServiceVersion;
                        if (azureOpenAIServiceVersion == null) {
                            azureOpenAIServiceVersion = AzureOpenAIServiceVersion.Companion.latestStableVersion();
                        }
                        this.replaceQueryParams("api-version", azureOpenAIServiceVersion.value());
                        break;
                    }
                    case 2: {
                        AzureOpenAIServiceVersion azureOpenAIServiceVersion = this.azureServiceVersion;
                        if (azureOpenAIServiceVersion != null) {
                            AzureOpenAIServiceVersion version = azureOpenAIServiceVersion;
                            boolean bl2 = false;
                            this.replaceQueryParams("api-version", version.value());
                        }
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            queryParams.replaceAll(this.queryParams.build());
            return new ClientOptions(httpClient, RetryingHttpClient.Companion.builder().httpClient(httpClient).sleeper(sleeper2).clock(this.clock).maxRetries(this.maxRetries).build(), this.checkJacksonVersionCompatibility, this.jsonMapper, streamHandlerExecutor2, sleeper2, this.clock, this.baseUrl, headers.build(), queryParams.build(), this.responseValidation, this.timeout, this.maxRetries, credential, this.azureServiceVersion, this.azureUrlPathMode, this.organization, this.project, this.webhookSecret, null);
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AzureUrlCategory.values().length];
                try {
                    nArray[AzureUrlCategory.AZURE_LEGACY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AzureUrlCategory.AZURE_UNIFIED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AzureUrlCategory.NON_AZURE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/openai/core/ClientOptions$Companion;", "", "()V", "PRODUCTION_URL", "", "builder", "Lcom/openai/core/ClientOptions$Builder;", "fromEnv", "Lcom/openai/core/ClientOptions;", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        @JvmStatic
        @NotNull
        public final ClientOptions fromEnv() {
            return this.builder().fromEnv().build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

