/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth.http;

import com.okta.commons.lang.ApplicationInfo;
import java.io.IOException;
import java.util.stream.Collectors;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class UserAgentRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final String USER_AGENT_VALUE = ApplicationInfo.get().entrySet().stream().map(e -> (String)e.getKey() + "/" + (String)e.getValue()).collect(Collectors.joining(" "));

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        request.getHeaders().add("User-Agent", USER_AGENT_VALUE);
        return execution.execute(request, body);
    }
}

