/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth.env;

import com.okta.spring.boot.oauth.env.RemappedPropertySource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

final class OktaOAuth2PropertiesMappingEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String OKTA_OAUTH_PREFIX = "okta.oauth2.";
    private static final String OKTA_OAUTH_ISSUER = "okta.oauth2.issuer";
    private static final String OKTA_OAUTH_CLIENT_ID = "okta.oauth2.client-id";
    private static final String OKTA_OAUTH_CLIENT_SECRET = "okta.oauth2.client-secret";
    private static final String OKTA_OAUTH_SCOPES = "okta.oauth2.scopes";

    OktaOAuth2PropertiesMappingEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        environment.getPropertySources().addLast(this.remappedOktaToStandardOAuthPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.remappedOktaOAuth2ScopesPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.oktaStaticDiscoveryPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.oktaRedirectUriPropertySource((Environment)environment));
    }

    private PropertySource remappedOktaToStandardOAuthPropertySource(Environment environment) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("spring.security.oauth2.client.registration.okta.client-id", OKTA_OAUTH_CLIENT_ID);
        aliasMap.put("spring.security.oauth2.client.registration.okta.client-secret", OKTA_OAUTH_CLIENT_SECRET);
        return new RemappedPropertySource("okta-to-oauth2", aliasMap, environment);
    }

    private PropertySource remappedOktaOAuth2ScopesPropertySource(final Environment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.security.oauth2.client.registration.okta.scope", "${okta.oauth2.scopes}");
        return new MapPropertySource("okta-scope-remaper", properties){

            public Object getProperty(String name) {
                if (this.containsProperty(name)) {
                    return Binder.get((Environment)environment).bind(OktaOAuth2PropertiesMappingEnvironmentPostProcessor.OKTA_OAUTH_SCOPES, Bindable.setOf(String.class)).orElse(null);
                }
                return null;
            }
        };
    }

    private PropertySource oktaRedirectUriPropertySource(Environment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.security.oauth2.client.registration.okta.redirect-uri", "{baseUrl}${okta.oauth2.redirect-uri}");
        return new ConditionalMapPropertySource("okta-redirect-uri-helper", properties, environment, "okta.oauth2.redirect-uri");
    }

    private PropertySource oktaStaticDiscoveryPropertySource(Environment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.security.oauth2.resourceserver.jwt.issuer-uri", "${okta.oauth2.issuer}");
        properties.put("spring.security.oauth2.resourceserver.jwt.jwk-set-uri", "${okta.oauth2.issuer}/v1/keys");
        properties.put("spring.security.oauth2.client.provider.okta.authorization-uri", "${okta.oauth2.issuer}/v1/authorize");
        properties.put("spring.security.oauth2.client.provider.okta.token-uri", "${okta.oauth2.issuer}/v1/token");
        properties.put("spring.security.oauth2.client.provider.okta.user-info-uri", "${okta.oauth2.issuer}/v1/userinfo");
        properties.put("spring.security.oauth2.client.provider.okta.jwk-set-uri", "${okta.oauth2.issuer}/v1/keys");
        properties.put("spring.security.oauth2.client.provider.okta.issuer-uri", "${okta.oauth2.issuer}");
        return new ConditionalMapPropertySource("okta-static-discovery", properties, environment, OKTA_OAUTH_ISSUER);
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    private static class ConditionalMapPropertySource
    extends MapPropertySource {
        private final Environment environment;
        private final String conditionalProperty;

        private ConditionalMapPropertySource(String name, Map<String, Object> source, Environment environment, String conditionalProperty) {
            super(name, source);
            this.environment = environment;
            this.conditionalProperty = conditionalProperty;
        }

        public Object getProperty(String name) {
            return this.containsProperty(name) ? super.getProperty(name) : null;
        }

        public boolean containsProperty(String name) {
            return super.containsProperty(name) && this.environment.containsProperty(this.conditionalProperty);
        }
    }
}

