/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.OktaJwtAuthenticationConverter;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import com.okta.spring.boot.oauth.http.UserAgentRequestInterceptor;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

final class OktaOAuth2Configurer
extends AbstractHttpConfigurer<OktaOAuth2Configurer, HttpSecurity> {
    private static final Logger log = LoggerFactory.getLogger(OktaOAuth2Configurer.class);

    OktaOAuth2Configurer() {
    }

    public void init(HttpSecurity http) throws Exception {
        ApplicationContext context = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        if (!context.getBeansOfType(OktaOAuth2Properties.class).isEmpty()) {
            OktaOAuth2Properties oktaOAuth2Properties = (OktaOAuth2Properties)context.getBean(OktaOAuth2Properties.class);
            if (!(context.getBeansOfType(OAuth2ClientProperties.class).isEmpty() || StringUtils.isEmpty((Object)oktaOAuth2Properties.getIssuer()) || StringUtils.isEmpty((Object)oktaOAuth2Properties.getClientId()))) {
                this.configureLogin(http, oktaOAuth2Properties);
                if (!context.getBeansOfType(OidcClientInitiatedLogoutSuccessHandler.class).isEmpty()) {
                    http.logout().logoutSuccessHandler((LogoutSuccessHandler)context.getBean(OidcClientInitiatedLogoutSuccessHandler.class));
                }
            } else {
                log.debug("OAuth/OIDC Login not configured due to missing issuer, client-id, or client-secret property");
            }
            if (!context.getBeansOfType(OAuth2ResourceServerProperties.class).isEmpty()) {
                OAuth2ResourceServerProperties resourceServerProperties = (OAuth2ResourceServerProperties)context.getBean(OAuth2ResourceServerProperties.class);
                if (!StringUtils.isEmpty((Object)resourceServerProperties.getJwt().getIssuerUri())) {
                    this.configureResourceServer(http, oktaOAuth2Properties);
                } else {
                    log.debug("OAuth resource server not configured due to missing issuer property");
                }
            } else {
                log.debug("OAuth resource server not configured due to missing OAuth2ResourceServerProperties bean");
            }
        }
    }

    private void configureLogin(HttpSecurity http, OktaOAuth2Properties oktaOAuth2Properties) throws Exception {
        http.oauth2Login().tokenEndpoint().accessTokenResponseClient(this.accessTokenResponseClient());
        if (oktaOAuth2Properties.getRedirectUri() != null) {
            http.oauth2Login().redirectionEndpoint().baseUri(oktaOAuth2Properties.getRedirectUri());
        }
    }

    private void configureResourceServer(HttpSecurity http, OktaOAuth2Properties oktaOAuth2Properties) throws Exception {
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter((Converter)new OktaJwtAuthenticationConverter(oktaOAuth2Properties.getGroupsClaim()));
    }

    private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient() {
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter()));
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        restTemplate.getInterceptors().add(new UserAgentRequestInterceptor());
        DefaultAuthorizationCodeTokenResponseClient accessTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        accessTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return accessTokenResponseClient;
    }
}

