/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.BrowserFriendlyBearerTokenServerAuthenticationEntryPoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.server.BearerTokenServerAuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.server.DelegatingServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;

public final class Okta {
    private Okta() {
    }

    public static ServerHttpSecurity configureResourceServer401ResponseBody(ServerHttpSecurity http) {
        return http.exceptionHandling().authenticationEntryPoint((ServerAuthenticationEntryPoint)new DelegatingServerAuthenticationEntryPoint(new DelegatingServerAuthenticationEntryPoint.DelegateEntry[]{new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.TEXT_PLAIN}), (ServerAuthenticationEntryPoint)new BrowserFriendlyBearerTokenServerAuthenticationEntryPoint()), new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.ALL}), (ServerAuthenticationEntryPoint)new BearerTokenServerAuthenticationEntryPoint())})).and();
    }

    public static HttpSecurity configureResourceServer401ResponseBody(HttpSecurity http) throws Exception {
        return (HttpSecurity)http.exceptionHandling().defaultAuthenticationEntryPointFor(Okta.authenticationEntryPoint(), Okta.textRequestMatcher(http)).and();
    }

    private static RequestMatcher textRequestMatcher(HttpSecurity http) {
        return new MediaTypeRequestMatcher((ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class), new MediaType[]{MediaType.TEXT_PLAIN});
    }

    private static AuthenticationEntryPoint authenticationEntryPoint() {
        BearerTokenAuthenticationEntryPoint bearerTokenEntryPoint = new BearerTokenAuthenticationEntryPoint();
        return (request, response, authException) -> {
            response.setContentType(MediaType.TEXT_PLAIN.toString());
            response.getWriter().print(Okta.statusAsString(Okta.getStatus(authException)));
            bearerTokenEntryPoint.commence(request, response, authException);
        };
    }

    static HttpStatus getStatus(AuthenticationException authException) {
        OAuth2Error error;
        if (authException instanceof OAuth2AuthenticationException && (error = ((OAuth2AuthenticationException)authException).getError()) instanceof BearerTokenError) {
            return ((BearerTokenError)error).getHttpStatus();
        }
        return HttpStatus.UNAUTHORIZED;
    }

    static String statusAsString(HttpStatus status) {
        return status.value() + " " + status.getReasonPhrase();
    }
}

