/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.sdk;

import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.commons.configcheck.ValidationResponse;
import com.okta.commons.http.config.Proxy;
import com.okta.commons.lang.Strings;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import com.okta.spring.boot.sdk.cache.SpringCacheManager;
import com.okta.spring.boot.sdk.config.OktaClientProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@AutoConfiguration
@Conditional(value={OktaApiConditions.class})
@ConditionalOnClass(value={Client.class})
@EnableConfigurationProperties(value={OktaClientProperties.class})
public class OktaSdkConfig {
    private final OktaClientProperties oktaClientProperties;
    private final CacheManager springCacheManager;

    public OktaSdkConfig(OktaClientProperties oktaClientProperties, @Autowired(required=false) CacheManager springCacheManager) {
        this.oktaClientProperties = oktaClientProperties;
        this.springCacheManager = springCacheManager;
    }

    @Bean
    protected Client oktaSdkClient() {
        ClientBuilder builder = Clients.builder().setCacheManager(this.oktaSdkCacheManager()).setAuthorizationMode(AuthorizationMode.SSWS).setConnectionTimeout(this.oktaClientProperties.getConnectionTimeout()).setClientCredentials(this.oktaSdkClientCredentials()).setOrgUrl(this.oktaClientProperties.getOrgUrl());
        Proxy proxy = this.oktaSdkProxy();
        if (proxy != null) {
            builder.setProxy(this.oktaSdkProxy());
        }
        return builder.build();
    }

    private Proxy oktaSdkProxy() {
        OktaClientProperties.ClientProxyInfo proxyInfo = this.oktaClientProperties.getProxy();
        if (proxyInfo == null || !Strings.hasText((String)proxyInfo.getHostname())) {
            return null;
        }
        Proxy proxy = Strings.hasText((String)proxyInfo.getUsername()) || Strings.hasText((String)proxyInfo.getPassword()) ? new Proxy(proxyInfo.getHostname(), proxyInfo.getPort(), proxyInfo.getUsername(), proxyInfo.getPassword()) : new Proxy(proxyInfo.getHostname(), proxyInfo.getPort());
        return proxy;
    }

    private com.okta.sdk.cache.CacheManager oktaSdkCacheManager() {
        return this.springCacheManager != null ? new SpringCacheManager(this.springCacheManager) : null;
    }

    @Bean
    @ConditionalOnMissingBean
    protected ClientCredentials oktaSdkClientCredentials() {
        return new TokenClientCredentials(this.oktaClientProperties.getToken());
    }

    static class OktaApiConditions
    extends SpringBootCondition {
        OktaApiConditions() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ValidationResponse tokenValidation = ConfigurationValidator.validateApiToken((String)context.getEnvironment().getProperty("okta.client.token"));
            if (!tokenValidation.isValid()) {
                return ConditionOutcome.noMatch((String)tokenValidation.getMessage());
            }
            ValidationResponse orgUrlValidation = ConfigurationValidator.validateOrgUrl((String)context.getEnvironment().getProperty("okta.client.orgUrl"));
            if (!orgUrlValidation.isValid() && !ConfigurationValidator.validateOrgUrl((String)context.getEnvironment().getProperty("okta.oauth2.issuer")).isValid()) {
                return ConditionOutcome.noMatch((String)orgUrlValidation.getMessage());
            }
            return ConditionOutcome.match((String)"Okta API token and orgUrl found");
        }
    }
}

