/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.lang;

import com.okta.commons.lang.Assert;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class Instants {
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(UTC_TIMEZONE);
        return df;
    });

    public static String toUtcIso8601(Date date) {
        return DATE_FORMAT.get().format(date);
    }

    public static long convertDateToLocalTime(long time, TimeZone to) {
        return Instants.convertDate(time, UTC_TIMEZONE, to);
    }

    public static long convertDateToUTC(long time, TimeZone from) {
        return Instants.convertDate(time, from, UTC_TIMEZONE);
    }

    public static long convertDate(long time, TimeZone from, TimeZone to) {
        return time + Instants.getTimeZoneOffset(time, from, to);
    }

    public static Date of(int year) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        TimeZone fromTimeZone = cal.getTimeZone();
        return new Date(Instants.convertDate(cal.getTimeInMillis(), fromTimeZone, UTC_TIMEZONE));
    }

    public static Date of(int year, int month) {
        Assert.isTrue(0 <= month && month <= 11, "month param must be a value from 0 (January) to 11 (December)");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        TimeZone fromTimeZone = cal.getTimeZone();
        return new Date(Instants.convertDate(cal.getTimeInMillis(), fromTimeZone, UTC_TIMEZONE));
    }

    public static Date of(int year, int month, int day) {
        Assert.isTrue(0 <= month && month <= 11, "month param must be a value from 0 (January) to 11 (December)");
        Assert.isTrue(1 <= day && day <= 31, "day param must be a value from 1 to 31");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        TimeZone fromTimeZone = cal.getTimeZone();
        return new Date(Instants.convertDate(cal.getTimeInMillis(), fromTimeZone, UTC_TIMEZONE));
    }

    public static Date of(int year, int month, int day, int hour) {
        Assert.isTrue(0 <= month && month <= 11, "month param must be a value from 0 (January) to 11 (December)");
        Assert.isTrue(1 <= day && day <= 31, "day param must be a value from 1 to 31");
        Assert.isTrue(0 <= hour && hour <= 23, "hour param must be a value from 0 to 23");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        TimeZone fromTimeZone = cal.getTimeZone();
        return new Date(Instants.convertDate(cal.getTimeInMillis(), fromTimeZone, UTC_TIMEZONE));
    }

    public static Date of(int year, int month, int day, int hour, int minute) {
        Assert.isTrue(0 <= month && month <= 11, "month param must be a value from 0 (January) to 11 (December)");
        Assert.isTrue(1 <= day && day <= 31, "day param must be a value from 1 to 31");
        Assert.isTrue(0 <= hour && hour <= 23, "hour param must be a value from 0 to 23");
        Assert.isTrue(0 <= minute && minute <= 59, "minute param must be a value from 0 to 59");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        TimeZone fromTimeZone = cal.getTimeZone();
        return new Date(Instants.convertDate(cal.getTimeInMillis(), fromTimeZone, UTC_TIMEZONE));
    }

    public static Date of(int year, int month, int day, int hour, int minute, int second) {
        Assert.isTrue(0 <= month && month <= 11, "month param must be a value from 0 (January) to 11 (December)");
        Assert.isTrue(1 <= day && day <= 31, "day param must be a value from 1 to 31");
        Assert.isTrue(0 <= hour && hour <= 23, "hour param must be a value from 1 to 23");
        Assert.isTrue(0 <= minute && minute <= 59, "minute param must be a value from 0 to 59");
        Assert.isTrue(0 <= second && second <= 59, "second param must be a value from 0 to 59");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        TimeZone fromTimeZone = cal.getTimeZone();
        return new Date(Instants.convertDate(cal.getTimeInMillis(), fromTimeZone, UTC_TIMEZONE));
    }

    public static Date of(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Assert.isTrue(0 <= month && month <= 11, "month param must be a value from 0 (January) to 11 (December)");
        Assert.isTrue(1 <= day && day <= 31, "day param must be a value from 1 to 31");
        Assert.isTrue(0 <= hour && hour <= 23, "hour param must be a value from 1 to 23");
        Assert.isTrue(0 <= minute && minute <= 59, "minute param must be a value from 0 to 59");
        Assert.isTrue(0 <= second && second <= 59, "second param must be a value from 0 to 59");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millisecond);
        TimeZone fromTimeZone = cal.getTimeZone();
        return new Date(Instants.convertDate(cal.getTimeInMillis(), fromTimeZone, UTC_TIMEZONE));
    }

    private static long getTimeZoneOffset(long time, TimeZone from, TimeZone to) {
        int diff;
        int fromOffset = from.getOffset(time);
        int toOffset = to.getOffset(time);
        if (fromOffset >= 0) {
            toOffset = toOffset > 0 ? -1 * toOffset : Math.abs(toOffset);
            diff = (fromOffset + toOffset) * -1;
        } else {
            if (toOffset <= 0) {
                toOffset = -1 * Math.abs(toOffset);
            }
            diff = Math.abs(fromOffset) + toOffset;
        }
        return diff;
    }
}

