/*
 * Decompiled with CFR 0.152.
 */
package com.okta.authn.sdk.http;

import com.okta.authn.sdk.http.BaseRequestParameter;
import com.okta.authn.sdk.http.RequestParameter;
import java.util.Collections;
import java.util.List;

public final class Header
extends BaseRequestParameter<String, List<String>>
implements RequestParameter {
    public Header(String key, String value) {
        this(key, Collections.singletonList(value));
    }

    public Header(String key, List<String> value) {
        super(key, value);
    }

    public static Header header(String key, String value) {
        return new Header(key, value);
    }

    public static Header header(String key, List<String> value) {
        return new Header(key, value);
    }

    public static Header xForwardedFor(String ipAddress) {
        return new Header("X-Forwarded-For", ipAddress);
    }

    public static Header xDeviceFingerprint(String fingerprint) {
        return new Header("X-Device-Fingerprint", fingerprint);
    }

    public static Header acceptLanguage(String language) {
        return new Header("Accept-Language", language);
    }

    public static Header userAgent(String userAgent) {
        return new Header("User-Agent", userAgent);
    }
}

