/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.rfc2251.RfcAddRequest;
import com.novell.ldap.rfc2251.RfcDelRequest;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcModifyDNRequest;
import com.novell.ldap.rfc2251.RfcModifyRequest;

public class LDAPLburpRequest {
    LDAPMessage request;
    public int opType;

    public LDAPLburpRequest(LDAPMessage lDAPMessage) {
        this.request = lDAPMessage;
        this.opType = this.request.getASN1Object().getType();
    }

    public ASN1Sequence getRequestASN1Sequence() {
        ASN1Sequence aSN1Sequence = null;
        RfcLDAPMessage rfcLDAPMessage = this.request.getASN1Object();
        switch (rfcLDAPMessage.getType()) {
            case 8: {
                RfcAddRequest rfcAddRequest;
                aSN1Sequence = rfcAddRequest = (RfcAddRequest)rfcLDAPMessage.getRequest();
                break;
            }
            case 6: {
                RfcModifyRequest rfcModifyRequest = (RfcModifyRequest)rfcLDAPMessage.getRequest();
                aSN1Sequence = rfcModifyRequest;
                break;
            }
            case 12: {
                RfcModifyDNRequest rfcModifyDNRequest = (RfcModifyDNRequest)rfcLDAPMessage.getRequest();
                aSN1Sequence = rfcModifyDNRequest;
                break;
            }
        }
        return aSN1Sequence;
    }

    public ASN1OctetString getRequestASN1OcString() {
        RfcDelRequest rfcDelRequest = null;
        RfcLDAPMessage rfcLDAPMessage = this.request.getASN1Object();
        if (rfcLDAPMessage.getType() == 10) {
            RfcDelRequest rfcDelRequest2;
            rfcDelRequest = rfcDelRequest2 = (RfcDelRequest)rfcLDAPMessage.getRequest();
        }
        return rfcDelRequest;
    }

    public ASN1SequenceOf getControlsASN1Object() {
        return this.request.getASN1Object().getControls();
    }
}

