/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPXMLHandler {
    private String elementName;
    private String value;
    private LDAPXMLHandler parenthandler;
    private HashMap m_handler_map = new HashMap();
    private int state = 0;
    private static final int INIT = 0;
    private static final int START = 1;
    private static final int CHILDELEMENT = 2;
    private static final int END = 3;
    private Object resultantObject = null;

    public LDAPXMLHandler(String ElementName, LDAPXMLHandler parent) {
        this.elementName = ElementName;
        this.parenthandler = parent;
        this.state = 0;
        this.initHandler();
    }

    protected LDAPXMLHandler getParent() {
        return this.parenthandler;
    }

    LDAPXMLHandler nextHandler(String childelementName) {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("nextHandler()");
        }
        this.state = 2;
        Object ob = this.m_handler_map.get(childelementName);
        return (LDAPXMLHandler)ob;
    }

    final void startElement() {
        this.state = 1;
    }

    final void value(StringBuffer buf) {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("value()");
        }
        this.value = buf.toString();
    }

    protected final String getName() {
        return this.elementName;
    }

    protected final String getValue() {
        return this.value;
    }

    protected final void setchildelement(LDAPXMLHandler handler) {
        if (this.state != 0) {
            throw new IllegalStateException("setchildelement");
        }
        this.m_handler_map.put(handler.getName(), handler);
    }

    protected void addValue(String tag, Object value) {
    }

    protected void initHandler() {
    }

    protected void endElement() {
    }

    protected void handleAttributes(Attributes attributes) throws SAXException {
    }

    public final Object getObject() {
        return this.resultantObject;
    }

    protected final void setObject(Object data) {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("setObject");
        }
        this.resultantObject = data;
        if (this.getParent() != null) {
            this.getParent().addValue(this.getName(), data);
        }
    }
}

