/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class GetReplicationFilterResponse
extends LDAPExtendedResponse {
    String[][] returnedFilter;

    public GetReplicationFilterResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        if (this.getResultCode() != 0) {
            this.returnedFilter = new String[0][0];
        } else {
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1Sequence returnedSequence = (ASN1Sequence)decoder.decode(returnedValue);
            if (returnedSequence == null) {
                throw new IOException("Decoding error");
            }
            int numberOfSequences = returnedSequence.size();
            this.returnedFilter = new String[numberOfSequences][];
            for (int classNumber = 0; classNumber < numberOfSequences; ++classNumber) {
                ASN1Sequence asn1_innerSequence = (ASN1Sequence)returnedSequence.get(classNumber);
                if (asn1_innerSequence == null) {
                    throw new IOException("Decoding error");
                }
                ASN1OctetString asn1_className = (ASN1OctetString)asn1_innerSequence.get(0);
                if (asn1_className == null) {
                    return;
                }
                ASN1Sequence asn1_attributeList = (ASN1Sequence)asn1_innerSequence.get(1);
                if (asn1_attributeList == null) {
                    throw new IOException("Decoding error");
                }
                int numberOfAttributes = asn1_attributeList.size();
                this.returnedFilter[classNumber] = new String[numberOfAttributes + 1];
                this.returnedFilter[classNumber][0] = asn1_className.stringValue();
                if (this.returnedFilter[classNumber][0] == null) {
                    throw new IOException("Decoding error");
                }
                for (int attributeNumber = 0; attributeNumber < numberOfAttributes; ++attributeNumber) {
                    ASN1OctetString asn1_attributeName = (ASN1OctetString)asn1_attributeList.get(attributeNumber);
                    if (asn1_attributeName == null) {
                        throw new IOException("Decoding error");
                    }
                    this.returnedFilter[classNumber][attributeNumber + 1] = asn1_attributeName.stringValue();
                    if (this.returnedFilter[classNumber][attributeNumber + 1] != null) continue;
                    throw new IOException("Decoding error");
                }
            }
        }
    }

    public String[][] getReplicationFilter() {
        return this.returnedFilter;
    }
}

