/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class GeneralDSEventData
implements EventResponseData {
    private static final int EVT_TAG_GEN_DSTIME = 1;
    private static final int EVT_TAG_GEN_MILLISEC = 2;
    private static final int EVT_TAG_GEN_VERB = 3;
    private static final int EVT_TAG_GEN_CURRPROC = 4;
    private static final int EVT_TAG_GEN_PERP = 5;
    private static final int EVT_TAG_GEN_INTEGERS = 6;
    private static final int EVT_TAG_GEN_STRINGS = 7;
    private final int dsTime;
    private final int milliseconds;
    private final int verb;
    private final int currentProcess;
    private final String perpetratorDN;
    private final int[] integerValues;
    private final String[] stringValues;

    public GeneralDSEventData(ASN1Object dsobject) throws IOException {
        int i;
        ASN1Sequence inteseq;
        byte[] bytedata = ((ASN1OctetString)dsobject).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(bytedata);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.dsTime = this.getTaggedintValue((ASN1Tagged)decode.decode(in, length), 1);
        this.milliseconds = this.getTaggedintValue((ASN1Tagged)decode.decode(in, length), 2);
        this.verb = this.getTaggedintValue((ASN1Tagged)decode.decode(in, length), 3);
        this.currentProcess = this.getTaggedintValue((ASN1Tagged)decode.decode(in, length), 4);
        this.perpetratorDN = this.getTaggedStringValue((ASN1Tagged)decode.decode(in, length), 5);
        ASN1Tagged temptaggedvalue = (ASN1Tagged)decode.decode(in, length);
        if (temptaggedvalue.getIdentifier().getTag() == 6) {
            inteseq = this.getTaggedSequence(temptaggedvalue, 6);
            ASN1Object[] intobject = inteseq.toArray();
            this.integerValues = new int[intobject.length];
            for (i = 0; i < intobject.length; ++i) {
                this.integerValues[i] = ((ASN1Integer)intobject[i]).intValue();
            }
            temptaggedvalue = (ASN1Tagged)decode.decode(in, length);
        } else {
            this.integerValues = null;
        }
        if (temptaggedvalue.getIdentifier().getTag() == 7 && temptaggedvalue.getIdentifier().getConstructed()) {
            inteseq = this.getTaggedSequence(temptaggedvalue, 7);
            ASN1Object[] stringobject = inteseq.toArray();
            this.stringValues = new String[stringobject.length];
            for (i = 0; i < stringobject.length; ++i) {
                this.stringValues[i] = ((ASN1OctetString)stringobject[i]).stringValue();
            }
        } else {
            this.stringValues = null;
        }
    }

    public int getCurrentProcess() {
        return this.currentProcess;
    }

    public int getDsTime() {
        return this.dsTime;
    }

    public int[] getIntegerValues() {
        return this.integerValues;
    }

    public int getMilliSeconds() {
        return this.milliseconds;
    }

    public String getPerpetratorDN() {
        return this.perpetratorDN;
    }

    public String[] getStringValues() {
        return this.stringValues;
    }

    public int getVerb() {
        return this.verb;
    }

    private int getTaggedintValue(ASN1Tagged tagvalue, int tagid) throws IOException {
        ASN1Object obj = tagvalue.taggedValue();
        if (tagid != tagvalue.getIdentifier().getTag()) {
            throw new IOException("Unknown Tagged Data");
        }
        byte[] databytes = ((ASN1OctetString)obj).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(databytes);
        LBERDecoder decode = new LBERDecoder();
        int length = databytes.length;
        return ((Long)decode.decodeNumeric(in, length)).intValue();
    }

    private String getTaggedStringValue(ASN1Tagged tagvalue, int tagid) throws IOException {
        ASN1Object obj = tagvalue.taggedValue();
        if (tagid != tagvalue.getIdentifier().getTag()) {
            throw new IOException("Unknown Tagged Data");
        }
        byte[] databytes = ((ASN1OctetString)obj).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(databytes);
        LBERDecoder decode = new LBERDecoder();
        int length = databytes.length;
        return (String)decode.decodeCharacterString(in, length);
    }

    private ASN1Sequence getTaggedSequence(ASN1Tagged tagvalue, int tagid) throws IOException {
        ASN1Object obj = tagvalue.taggedValue();
        if (tagid != tagvalue.getIdentifier().getTag()) {
            throw new IOException("Unknown Tagged Data");
        }
        byte[] databytes = ((ASN1OctetString)obj).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(databytes);
        LBERDecoder decode = new LBERDecoder();
        int length = databytes.length;
        return new ASN1Sequence(decode, in, length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[GeneralDSEventData");
        buf.append("(DSTime =" + this.getDsTime() + ")");
        buf.append("(MilliSeconds=" + this.getMilliSeconds() + ")");
        buf.append("(verb =" + this.getVerb() + ")");
        buf.append("(currentProcess " + this.getCurrentProcess() + ")");
        buf.append("(PerpetartorDN =" + this.getPerpetratorDN() + ")");
        buf.append("(Integer Values =" + this.getIntegerValues() + ")");
        buf.append("(String Values =" + this.getStringValues() + ")");
        buf.append("]");
        return buf.toString();
    }
}

