/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EdirEventSpecifier;
import com.novell.ldap.rfc2251.RfcLDAPMessage;

public class MonitorEventResponse
extends LDAPExtendedResponse {
    private EdirEventSpecifier[] specifierlist = new EdirEventSpecifier[0];

    public MonitorEventResponse(RfcLDAPMessage message) throws LDAPException {
        super(message);
        byte[] returnedValue = this.getValue();
        if (returnedValue == null) {
            throw new LDAPException(LDAPException.resultCodeToString(this.getResultCode()), this.getResultCode(), null);
        }
        LBERDecoder decoder = new LBERDecoder();
        ASN1Sequence sequence = (ASN1Sequence)decoder.decode(returnedValue);
        int length = ((ASN1Integer)sequence.get(0)).intValue();
        ASN1Set sequenceset = (ASN1Set)sequence.get(1);
        this.specifierlist = new EdirEventSpecifier[length];
        for (int i = 0; i < length; ++i) {
            ASN1Sequence eventspecifiersequence = (ASN1Sequence)sequenceset.get(i);
            int classfication = ((ASN1Integer)eventspecifiersequence.get(0)).intValue();
            int enumtype = ((ASN1Enumerated)eventspecifiersequence.get(1)).intValue();
            this.specifierlist[i] = new EdirEventSpecifier(classfication, enumtype);
        }
    }

    public EdirEventSpecifier[] getSpecifierList() {
        return this.specifierlist;
    }
}

