/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Null;
import com.novell.ldap.asn1.ASN1Numeric;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Structured;
import com.novell.ldap.asn1.ASN1Tagged;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LBEREncoder
implements ASN1Encoder {
    public void encode(ASN1Boolean b, OutputStream out) throws IOException {
        this.encode(b.getIdentifier(), out);
        out.write(1);
        out.write(b.booleanValue() ? -1 : 0);
    }

    public final void encode(ASN1Numeric n, OutputStream out) throws IOException {
        int len;
        byte[] octets = new byte[8];
        long value = n.longValue();
        long endValue = value < 0L ? -1L : 0L;
        long endSign = endValue & 0x80L;
        for (len = 0; len == 0 || value != endValue || (long)(octets[len - 1] & 0x80) != endSign; value >>= 8, len = (int)((byte)(len + 1))) {
            octets[len] = (byte)(value & 0xFFL);
        }
        this.encode(n.getIdentifier(), out);
        out.write(len);
        for (int i = len - 1; i >= 0; --i) {
            out.write(octets[i]);
        }
    }

    public final void encode(ASN1Null n, OutputStream out) throws IOException {
        this.encode(n.getIdentifier(), out);
        out.write(0);
    }

    public final void encode(ASN1OctetString os, OutputStream out) throws IOException {
        this.encode(os.getIdentifier(), out);
        this.encodeLength(os.byteValue().length, out);
        out.write(os.byteValue());
    }

    public final void encode(ASN1Structured c, OutputStream out) throws IOException {
        this.encode(c.getIdentifier(), out);
        ASN1Object[] value = c.toArray();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (int i = 0; i < value.length; ++i) {
            value[i].encode(this, output);
        }
        this.encodeLength(output.size(), out);
        out.write(output.toByteArray());
    }

    public final void encode(ASN1Tagged t, OutputStream out) throws IOException {
        if (t.isExplicit()) {
            this.encode(t.getIdentifier(), out);
            ByteArrayOutputStream encodedContent = new ByteArrayOutputStream();
            t.taggedValue().encode(this, encodedContent);
            this.encodeLength(encodedContent.size(), out);
            out.write(encodedContent.toByteArray());
        } else {
            t.taggedValue().encode(this, out);
        }
    }

    public final void encode(ASN1Identifier id, OutputStream out) throws IOException {
        int c = id.getASN1Class();
        int t = id.getTag();
        byte ccf = (byte)(c << 6 | (id.getConstructed() ? 32 : 0));
        if (t < 30) {
            out.write(ccf | t);
        } else {
            out.write(ccf | 0x1F);
            this.encodeTagInteger(t, out);
        }
    }

    private final void encodeLength(int length, OutputStream out) throws IOException {
        if (length < 128) {
            out.write(length);
        } else {
            byte[] octets = new byte[4];
            int n = 0;
            while (length != 0) {
                octets[n] = (byte)(length & 0xFF);
                length >>= 8;
                n = (byte)(n + 1);
            }
            out.write(0x80 | n);
            for (int i = n - 1; i >= 0; --i) {
                out.write(octets[i]);
            }
        }
    }

    private final void encodeTagInteger(int value, OutputStream out) throws IOException {
        byte[] octets = new byte[5];
        int n = 0;
        while (value != 0) {
            octets[n] = (byte)(value & 0x7F);
            value >>= 7;
            ++n;
        }
        for (int i = n - 1; i > 0; --i) {
            out.write(octets[i] | 0x80);
        }
        out.write(octets[0]);
    }
}

