/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPTLSSocketFactory;
import com.novell.ldap.client.Debug;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.ietf.ldap.LDAPSocketFactory;

public class LDAPJSSEStartTLSFactory
implements LDAPTLSSocketFactory,
LDAPSocketFactory {
    private SSLSocketFactory factory;
    private boolean pauseForHandShake = false;

    public LDAPJSSEStartTLSFactory() {
        this.factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public LDAPJSSEStartTLSFactory(SSLSocketFactory factory) {
        this.factory = factory;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new Socket(host, port);
    }

    public Socket createSocket(Socket socket) throws IOException, UnknownHostException {
        SSLSocket tls = (SSLSocket)this.factory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), false);
        tls.addHandshakeCompletedListener(new HandShakeFinished(this));
        this.pauseForHandShake = true;
        tls.startHandshake();
        try {
            while (this.pauseForHandShake) {
                Thread.currentThread();
                Thread.sleep(5L);
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Internal error: Could not pause main thread while waiting for TLS handshake to complete");
        }
        Debug.trace("TraceTLS", "startTLS: TLS handshake complete");
        String[] suites = tls.getSupportedCipherSuites();
        for (int i = 0; i < suites.length; ++i) {
            Debug.trace("TraceTLS", "startTLS: suite[" + i + "]=" + suites[i]);
        }
        return tls;
    }

    private class HandShakeFinished
    implements HandshakeCompletedListener {
        private LDAPJSSEStartTLSFactory ssf;

        public HandShakeFinished(LDAPJSSEStartTLSFactory ssf) {
            this.ssf = ssf;
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            Debug.trace("Messages", "startTLS: Handshake is complete");
            this.ssf.pauseForHandShake = false;
        }
    }
}

