/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.client.RespExtensionSet;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcExtendedResponse;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcReferral;
import java.io.IOException;
import java.net.MalformedURLException;

public class LDAPExtendedResponse
extends LDAPResponse {
    private static RespExtensionSet registeredResponses = new RespExtensionSet();

    public LDAPExtendedResponse() {
        super(24);
    }

    public LDAPExtendedResponse(int resultCode, String matchedDN, String serverMessage, String[] referrals, LDAPControl[] controls, String extendedid, byte[] extendedvalue) throws MalformedURLException {
        this(new RfcLDAPMessage(new RfcExtendedResponse(new ASN1Enumerated(resultCode), matchedDN != null ? new RfcLDAPDN(matchedDN) : new RfcLDAPDN(""), serverMessage != null ? new RfcLDAPString(serverMessage) : new RfcLDAPString(""), referrals != null ? new RfcReferral(referrals) : null, extendedid != null ? new RfcLDAPOID(extendedid) : null, extendedvalue != null ? new ASN1OctetString(extendedvalue) : null)));
    }

    public LDAPExtendedResponse(RfcLDAPMessage message) {
        super(message);
    }

    public String getID() {
        RfcLDAPOID respOID = ((RfcExtendedResponse)this.message.getResponse()).getResponseName();
        if (respOID == null) {
            return null;
        }
        return respOID.stringValue();
    }

    public byte[] getValue() {
        ASN1OctetString tempString = ((RfcExtendedResponse)this.message.getResponse()).getResponse();
        if (tempString == null) {
            return null;
        }
        return tempString.byteValue();
    }

    public static void register(String oid, Class extendedResponseClass) {
        registeredResponses.registerResponseExtension(oid, extendedResponseClass);
    }

    public static RespExtensionSet getRegisteredResponses() {
        return registeredResponses;
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPExtendedResponse)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPExtendedResponse object");
        }
        LDAPExtendedResponse tmp = (LDAPExtendedResponse)readObject;
        int type = tmp.getType();
        int resultCode = tmp.getResultCode();
        String matchedDN = tmp.getMatchedDN();
        String serverMessage = tmp.getErrorMessage();
        String[] referrals = tmp.getReferrals();
        String extendedid = tmp.getID();
        byte[] extendedvalue = tmp.getValue();
        tmp = null;
        this.message = new RfcLDAPMessage(new RfcExtendedResponse(new ASN1Enumerated(resultCode), matchedDN != null ? new RfcLDAPDN(matchedDN) : new RfcLDAPDN(""), serverMessage != null ? new RfcLDAPString(serverMessage) : new RfcLDAPString(""), referrals != null ? new RfcReferral(referrals) : null, extendedid != null ? new RfcLDAPOID(extendedid) : null, extendedvalue != null ? new ASN1OctetString(extendedvalue) : null));
        readObject = null;
    }
}

