/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.shaded.json.reader;

import com.nimbusds.jose.shaded.json.JSONObject;
import com.nimbusds.jose.shaded.json.JSONStyle;
import com.nimbusds.jose.shaded.json.JSONUtil;
import com.nimbusds.jose.shaded.json.reader.JsonWriterI;
import java.io.IOException;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.asm.FieldFilter;

public class BeansWriterASM
implements JsonWriterI<Object> {
    @Override
    public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
        Class<?> cls = value.getClass();
        boolean needSep = false;
        BeansAccess fields = BeansAccess.get(cls, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
        out.append('{');
        for (Accessor field : fields.getAccessors()) {
            Object v = fields.get(value, field.getIndex());
            if (v == null && compression.ignoreNull()) continue;
            if (needSep) {
                out.append(',');
            } else {
                needSep = true;
            }
            String key = field.getName();
            JSONObject.writeJSONKV(key, v, out, compression);
        }
        out.append('}');
    }
}

