/*
 * nimbus-jose-jwt
 *
 * Copyright 2012-2016, Connect2id Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use
 * this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.nimbusds.jose;


/**
 * Key source exception.
 *
 * @author Vladimir Dzhuvinov
 * @version 2023-01-05
 */
public class KeySourceException extends JOSEException {
	

	/**
	 * Creates a new key source exception.
	 *
	 * @param message The message.
	 */
	public KeySourceException(final String message) {
		super(message);
	}


	/**
	 * Creates a new key source exception.
	 *
	 * @param message The message.
	 * @param cause   The cause.
	 */
	public KeySourceException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * Creates a new key source exception.
	 *
	 * @param cause The cause.
	 */

	public KeySourceException(final Throwable cause) {
		super(cause);
	}

	
	/**
	 * Creates a new key source exception.
	 */
	public KeySourceException() {
		super();
	}
}

