/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypterMulti;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.crypto.impl.ECDH;
import com.nimbusds.jose.crypto.impl.ECDHCryptoProvider;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jose.util.Pair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDHEncrypterMulti
extends ECDHCryptoProvider
implements JWEEncrypterMulti {
    public static final Set<Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final List<Pair<UnprotectedHeader, ECKey>> recipients;

    public ECDHEncrypterMulti(List<Pair<UnprotectedHeader, ECKey>> recipients) throws JOSEException {
        super(recipients.get(0).getRight().getCurve());
        this.recipients = recipients;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        ECKey ephemeralKeyPair = new ECKeyGenerator(this.getCurve()).generate();
        ECPublicKey ephemeralPublicKey = ephemeralKeyPair.toECPublicKey();
        ECPrivateKey ephemeralPrivateKey = ephemeralKeyPair.toECPrivateKey();
        JWEHeader updatedHeader = new JWEHeader.Builder(header).ephemeralPublicKey(new ECKey.Builder(this.getCurve(), ephemeralPublicKey).build()).build();
        ArrayList<Pair<UnprotectedHeader, SecretKey>> sharedKeys = new ArrayList<Pair<UnprotectedHeader, SecretKey>>();
        for (Pair<UnprotectedHeader, ECKey> recipient : this.recipients) {
            SecretKey Z = ECDH.deriveSharedSecret(recipient.getRight().toECPublicKey(), ephemeralPrivateKey, this.getJCAContext().getKeyEncryptionProvider());
            sharedKeys.add(Pair.of(recipient.getLeft(), Z));
        }
        return this.encryptMulti(updatedHeader, sharedKeys, clearText);
    }

    static {
        LinkedHashSet<Curve> curves = new LinkedHashSet<Curve>();
        curves.add(Curve.P_256);
        curves.add(Curve.P_384);
        curves.add(Curve.P_521);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(curves);
    }
}

