/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.proc;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyConverter;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.AbstractJWKSelectorWithSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import java.security.Key;
import java.security.PublicKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWSVerificationKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWSKeySelector<C> {
    private final JWSAlgorithm jwsAlg;

    public JWSVerificationKeySelector(JWSAlgorithm jwsAlg, JWKSource<C> jwkSource) {
        super(jwkSource);
        if (jwsAlg == null) {
            throw new IllegalArgumentException("The JWS algorithm must not be null");
        }
        this.jwsAlg = jwsAlg;
    }

    public JWSAlgorithm getExpectedJWSAlgorithm() {
        return this.jwsAlg;
    }

    protected JWKMatcher createJWKMatcher(JWSHeader jwsHeader) {
        if (!this.getExpectedJWSAlgorithm().equals(jwsHeader.getAlgorithm())) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains(this.getExpectedJWSAlgorithm()) || JWSAlgorithm.Family.EC.contains(this.getExpectedJWSAlgorithm())) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm(this.getExpectedJWSAlgorithm())).keyID(jwsHeader.getKeyID()).keyUses(KeyUse.SIGNATURE, null).algorithms(this.getExpectedJWSAlgorithm(), null).build();
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(this.getExpectedJWSAlgorithm())) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm(this.getExpectedJWSAlgorithm())).keyID(jwsHeader.getKeyID()).privateOnly(true).algorithms(this.getExpectedJWSAlgorithm(), null).build();
        }
        return null;
    }

    @Override
    public List<Key> selectJWSKeys(JWSHeader jwsHeader, C context) {
        if (!this.jwsAlg.equals(jwsHeader.getAlgorithm())) {
            return Collections.emptyList();
        }
        JWKMatcher jwkMatcher = this.createJWKMatcher(jwsHeader);
        if (jwkMatcher == null) {
            return Collections.emptyList();
        }
        List<JWK> jwkMatches = this.getJWKSource().get(new JWKSelector(jwkMatcher), context);
        LinkedList<Key> sanitizedKeyList = new LinkedList<Key>();
        for (Key key : KeyConverter.toJavaKeys(jwkMatches)) {
            if (!(key instanceof PublicKey) && !(key instanceof SecretKey)) continue;
            sanitizedKeyList.add(key);
        }
        return sanitizedKeyList;
    }
}

