/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.BaseJWSProvider;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class MACProvider
extends BaseJWSProvider {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;
    private final byte[] sharedSecret;

    public int getMinRequiredSecretSize(JWSAlgorithm hmacAlg) throws JOSEException {
        if (JWSAlgorithm.HS256.equals(hmacAlg)) {
            return 256;
        }
        if (JWSAlgorithm.HS384.equals(hmacAlg)) {
            return 384;
        }
        if (JWSAlgorithm.HS512.equals(hmacAlg)) {
            return 512;
        }
        throw new JOSEException("Unsupported HMAC algorithm, must be HS256, HS384 or HS512");
    }

    protected static String getJCAAlgorithmName(JWSAlgorithm alg) throws JOSEException {
        if (alg.equals(JWSAlgorithm.HS256)) {
            return "HMACSHA256";
        }
        if (alg.equals(JWSAlgorithm.HS384)) {
            return "HMACSHA384";
        }
        if (alg.equals(JWSAlgorithm.HS512)) {
            return "HMACSHA512";
        }
        throw new JOSEException("Unsupported HMAC algorithm, must be HS256, HS384 or HS512");
    }

    protected MACProvider(byte[] sharedSecret) {
        super(SUPPORTED_ALGORITHMS);
        if (sharedSecret.length < 32) {
            throw new IllegalArgumentException("The shared secret size must be at least 256 bits");
        }
        this.sharedSecret = sharedSecret;
    }

    protected MACProvider(String sharedSecretString) {
        this(sharedSecretString.getBytes(Charset.forName("UTF-8")));
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public String getSharedSecretString() {
        return new String(this.sharedSecret, Charset.forName("UTF-8"));
    }

    static {
        HashSet<JWSAlgorithm> algs = new HashSet<JWSAlgorithm>();
        algs.add(JWSAlgorithm.HS256);
        algs.add(JWSAlgorithm.HS384);
        algs.add(JWSAlgorithm.HS512);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
    }
}

