/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.ECDSAParameters;
import com.nimbusds.jose.crypto.ECDSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.math.BigInteger;
import net.jcip.annotations.ThreadSafe;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;

@ThreadSafe
public class ECDSASigner
extends ECDSAProvider
implements JWSSigner {
    private final BigInteger privateKey;

    public ECDSASigner(BigInteger privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private key must not be null");
        }
        this.privateKey = privateKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    private static byte[] doECDSA(ECPrivateKeyParameters ecPrivateKeyParameters, byte[] bytes) {
        org.bouncycastle.crypto.signers.ECDSASigner signer = new org.bouncycastle.crypto.signers.ECDSASigner();
        signer.init(true, (CipherParameters)ecPrivateKeyParameters);
        BigInteger[] res = signer.generateSignature(bytes);
        BigInteger r = res[0];
        BigInteger s = res[1];
        return ECDSASigner.formatSignature(r, s);
    }

    private static byte[] formatSignature(BigInteger r, BigInteger s) {
        byte[] rBytes = r.toByteArray();
        byte[] sBytes = s.toByteArray();
        byte[] rsBytes = new byte[64];
        for (int i = 0; i < rsBytes.length; ++i) {
            rsBytes[i] = 0;
        }
        if (rBytes.length >= 32) {
            System.arraycopy(rBytes, rBytes.length - 32, rsBytes, 0, 32);
        } else {
            System.arraycopy(rBytes, 0, rsBytes, 32 - rBytes.length, rBytes.length);
        }
        if (sBytes.length >= 32) {
            System.arraycopy(sBytes, sBytes.length - 32, rsBytes, 32, 32);
        } else {
            System.arraycopy(sBytes, 0, rsBytes, 64 - sBytes.length, sBytes.length);
        }
        return rsBytes;
    }

    public Base64URL sign(ReadOnlyJWSHeader header, byte[] signableContent) throws JOSEException {
        ECDSAParameters initParams = ECDSASigner.getECDSAParameters(header.getAlgorithm());
        X9ECParameters x9ECParameters = initParams.getX9ECParameters();
        Digest digest = initParams.getDigest();
        ECDomainParameters ecParameterSpec = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(this.privateKey, ecParameterSpec);
        digest.update(signableContent, 0, signableContent.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        byte[] sig = ECDSASigner.doECDSA(ecPrivateKeyParameters, out);
        return Base64URL.encode(sig);
    }
}

