/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import java.util.Arrays;

final class Base64Codec {
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] CA_URL_SAFE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final int[] IA = new int[256];

    Base64Codec() {
    }

    public static int computeEncodedLength(int inputLength, boolean urlSafe) {
        if (inputLength == 0) {
            return 0;
        }
        if (urlSafe) {
            int fullQuadLength = inputLength / 3 << 2;
            int remainder = inputLength % 3;
            return remainder == 0 ? fullQuadLength : fullQuadLength + remainder + 1;
        }
        return (inputLength - 1) / 3 + 1 << 2;
    }

    public static String normalizeEncodedString(String value) {
        int i;
        int len = value.length();
        int padLength = len % 4 == 0 ? 0 : 4 - len % 4;
        char[] chars = new char[len + padLength];
        value.getChars(0, len, chars, 0);
        for (i = 0; i < padLength; ++i) {
            chars[len + i] = 61;
        }
        for (i = 0; i < len; ++i) {
            if (chars[i] == '_') {
                chars[i] = 47;
                continue;
            }
            if (chars[i] != '-') continue;
            chars[i] = 43;
        }
        return new String(chars);
    }

    public static char[] encodeToChar(byte[] sArr, boolean urlSafe) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int dLen = Base64Codec.computeEncodedLength(sLen, urlSafe);
        char[] out = new char[dLen];
        int s = 0;
        int d = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            if (urlSafe) {
                out[d++] = CA_URL_SAFE[i >>> 18 & 0x3F];
                out[d++] = CA_URL_SAFE[i >>> 12 & 0x3F];
                out[d++] = CA_URL_SAFE[i >>> 6 & 0x3F];
                out[d++] = CA_URL_SAFE[i & 0x3F];
                continue;
            }
            out[d++] = CA[i >>> 18 & 0x3F];
            out[d++] = CA[i >>> 12 & 0x3F];
            out[d++] = CA[i >>> 6 & 0x3F];
            out[d++] = CA[i & 0x3F];
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            if (urlSafe) {
                if (left == 2) {
                    out[dLen - 3] = CA_URL_SAFE[i >> 12];
                    out[dLen - 2] = CA_URL_SAFE[i >>> 6 & 0x3F];
                    out[dLen - 1] = CA_URL_SAFE[i & 0x3F];
                } else {
                    out[dLen - 2] = CA_URL_SAFE[i >> 12];
                    out[dLen - 1] = CA_URL_SAFE[i >>> 6 & 0x3F];
                }
            } else {
                out[dLen - 4] = CA[i >> 12];
                out[dLen - 3] = CA[i >>> 6 & 0x3F];
                out[dLen - 2] = left == 2 ? CA[i & 0x3F] : 61;
                out[dLen - 1] = 61;
            }
        }
        return out;
    }

    public static final String encodeToString(byte[] sArr, boolean urlSafe) {
        return new String(Base64Codec.encodeToChar(sArr, urlSafe));
    }

    public static final byte[] decode(String str) {
        if (str == null || str.isEmpty()) {
            return new byte[0];
        }
        String nStr = Base64Codec.normalizeEncodedString(str);
        int sLen = nStr.length();
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (IA[nStr.charAt(i)] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return new byte[0];
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && IA[nStr.charAt(--i)] <= 0) {
            if (nStr.charAt(i) != '=') continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[nStr.charAt(s++)]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    static {
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (int i = 0; i < iS; ++i) {
            Base64Codec.IA[Base64Codec.CA[i]] = i;
        }
        Base64Codec.IA[61] = 0;
    }
}

