/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.DefaultHeaderFilter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSHeaderFilter;
import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultJWSHeaderFilter
extends DefaultHeaderFilter
implements JWSHeaderFilter {
    private final Set<JWSAlgorithm> algs;
    private Set<JWSAlgorithm> acceptedAlgs;

    private static void validateAcceptedParameters(Set<String> acceptedParams) {
        if (!acceptedParams.contains("alg")) {
            throw new IllegalArgumentException("The accepted JWS header parameters set must include at least the \"alg\" parameter");
        }
    }

    public DefaultJWSHeaderFilter(Set<JWSAlgorithm> algs) {
        this(algs, JWSHeader.getRegisteredParameterNames());
    }

    public DefaultJWSHeaderFilter(Set<JWSAlgorithm> algs, Set<String> acceptedParams) {
        super(acceptedParams);
        DefaultJWSHeaderFilter.validateAcceptedParameters(acceptedParams);
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWS algorithms set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
        this.acceptedAlgs = this.algs;
    }

    public Set<JWSAlgorithm> supportedAlgorithms() {
        return this.algs;
    }

    @Override
    public Set<JWSAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWSAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWS algorithms set must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("One or more of the JWE algorithms is not in the supported set");
        }
        this.acceptedAlgs = Collections.unmodifiableSet(acceptedAlgs);
    }

    @Override
    public void setAcceptedParameters(Set<String> acceptedParams) {
        DefaultJWSHeaderFilter.validateAcceptedParameters(acceptedParams);
        super.setAcceptedParameters(acceptedParams);
    }
}

