/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.Use;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWKSelector {
    private Set<KeyType> types;
    private Set<Use> uses;
    private Set<Algorithm> algs;
    private Set<String> ids;
    private boolean privateOnly = false;
    private boolean publicOnly = false;

    public Set<KeyType> getKeyTypes() {
        return this.types;
    }

    public void setKeyType(KeyType kty) {
        this.types = new HashSet<KeyType>(Arrays.asList(kty));
    }

    public void setKeyTypes(KeyType ... types) {
        this.setKeyTypes(new HashSet<KeyType>(Arrays.asList(types)));
    }

    public void setKeyTypes(Set<KeyType> types) {
        this.types = types;
    }

    public Set<Use> getKeyUses() {
        return this.uses;
    }

    public void setKeyUse(Use use) {
        this.uses = new HashSet<Use>(Arrays.asList(use));
    }

    public void setKeyUses(Use ... uses) {
        this.setKeyUses(new HashSet<Use>(Arrays.asList(uses)));
    }

    public void setKeyUses(Set<Use> uses) {
        this.uses = uses;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algs;
    }

    public void setAlgorithm(Algorithm alg) {
        this.algs = new HashSet<Algorithm>(Arrays.asList(alg));
    }

    public void setAlgorithms(Algorithm ... algs) {
        this.setAlgorithms(new HashSet<Algorithm>(Arrays.asList(algs)));
    }

    public void setAlgorithms(Set<Algorithm> algs) {
        this.algs = algs;
    }

    public Set<String> getKeyIDs() {
        return this.ids;
    }

    public void setKeyIDs(String ... ids) {
        this.setKeyIDs(new HashSet<String>(Arrays.asList(ids)));
    }

    public void setKeyIDs(Set<String> ids) {
        this.ids = ids;
    }

    public void setKeyID(String id) {
        this.ids = new HashSet<String>(Arrays.asList(id));
    }

    public boolean isPrivateOnly() {
        return this.privateOnly;
    }

    public void setPrivateOnly(boolean privateOnly) {
        this.privateOnly = privateOnly;
    }

    public boolean isPublicOnly() {
        return this.publicOnly;
    }

    public void setPublicOnly(boolean publicOnly) {
        this.publicOnly = publicOnly;
    }

    public List<JWK> select(JWKSet jwkSet) {
        LinkedList<JWK> matches = new LinkedList<JWK>();
        if (jwkSet == null) {
            return matches;
        }
        for (JWK key : jwkSet.getKeys()) {
            if (this.privateOnly && !key.isPrivate() || this.publicOnly && key.isPrivate() || this.types != null && !this.types.contains(key.getKeyType()) || this.uses != null && !this.uses.contains((Object)key.getKeyUse()) || this.algs != null && !this.algs.contains(key.getAlgorithm()) || this.ids != null && !this.ids.contains(key.getKeyID())) continue;
            matches.add(key);
        }
        return matches;
    }
}

