/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.DefaultJWEHeaderFilter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeaderFilter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AES;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.RSA1_5;
import com.nimbusds.jose.crypto.RSACryptoProvider;
import com.nimbusds.jose.crypto.RSA_OAEP;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.StringUtils;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;

public class RSADecrypter
extends RSACryptoProvider
implements JWEDecrypter {
    private final DefaultJWEHeaderFilter headerFilter;
    private RSAPrivateKey privateKey;

    public RSADecrypter(RSAPrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        this.privateKey = privateKey;
        this.headerFilter = new DefaultJWEHeaderFilter(this.supportedAlgorithms(), this.supportedEncryptionMethods());
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public JWEHeaderFilter getJWEHeaderFilter() {
        return this.headerFilter;
    }

    public byte[] decrypt(ReadOnlyJWEHeader readOnlyJWEHeader, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        byte[] plainText;
        if (encryptedKey == null) {
            throw new JOSEException("The encrypted key must not be null");
        }
        if (iv == null) {
            throw new JOSEException("The initialization vector (IV) must not be null");
        }
        if (authTag == null) {
            throw new JOSEException("The authentication tag must not be null");
        }
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        SecretKey cek = null;
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            int keyLength = readOnlyJWEHeader.getEncryptionMethod().cekBitLength();
            SecretKey randomCEK = AES.generateKey(keyLength);
            try {
                cek = RSA1_5.decryptCEK(this.privateKey, encryptedKey.decode(), keyLength);
            }
            catch (Exception e) {
                cek = randomCEK;
            }
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            cek = RSA_OAEP.decryptCEK(this.privateKey, encryptedKey.decode());
        } else {
            throw new JOSEException("Unsupported JWE algorithm, must be RSA1_5 or RSA_OAEP");
        }
        byte[] aad = StringUtils.toByteArray(readOnlyJWEHeader.toBase64URL() + "." + encryptedKey);
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            plainText = AESCBC.decryptAuthenticated(cek, iv.decode(), cipherText.decode(), aad, authTag.decode());
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            plainText = AESGCM.decrypt(cek, iv.decode(), cipherText.decode(), aad, authTag.decode());
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        return DeflateHelper.applyDecompression(readOnlyJWEHeader, plainText);
    }
}

