/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.BaseJWSProvider;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.util.HashSet;
import java.util.Set;

abstract class RSASSAProvider
extends BaseJWSProvider {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    protected RSASSAProvider() {
        super(SUPPORTED_ALGORITHMS);
    }

    protected static Signature getRSASignerAndVerifier(JWSAlgorithm alg) throws JOSEException {
        String internalAlgName = null;
        if (alg.equals(JWSAlgorithm.RS256)) {
            internalAlgName = "SHA256withRSA";
        } else if (alg.equals(JWSAlgorithm.RS384)) {
            internalAlgName = "SHA384withRSA";
        } else if (alg.equals(JWSAlgorithm.RS512)) {
            internalAlgName = "SHA512withRSA";
        } else {
            throw new JOSEException("Unsupported RSASSA algorithm, must be RS256, RS384 or RS512");
        }
        try {
            return Signature.getInstance(internalAlgName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException("Unsupported RSASSA algorithm: " + e.getMessage(), e);
        }
    }

    static {
        HashSet<JWSAlgorithm> algs = new HashSet<JWSAlgorithm>();
        algs.add(JWSAlgorithm.RS256);
        algs.add(JWSAlgorithm.RS384);
        algs.add(JWSAlgorithm.RS512);
        SUPPORTED_ALGORITHMS = algs;
    }
}

