/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class AESCBC {
    public static final int IV_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom randomGen) {
        byte[] bytes = new byte[16];
        randomGen.nextBytes(bytes);
        return bytes;
    }

    private static Cipher createAESCBCCipher(SecretKey secretKey, boolean forEncryption, byte[] iv) throws JOSEException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keyspec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            if (forEncryption) {
                cipher.init(1, (Key)keyspec, ivSpec);
            } else {
                cipher.init(2, (Key)keyspec, ivSpec);
            }
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        return cipher;
    }

    public static byte[] encrypt(SecretKey secretKey, byte[] iv, byte[] plainText) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, true, iv);
        try {
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] iv, byte[] cipherText) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, false, iv);
        try {
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    private AESCBC() {
    }
}

