/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.CommonSEHeader;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWSHeader
extends CommonSEHeader
implements ReadOnlyJWSHeader {
    private static final Set<String> RESERVED_PARAMETER_NAMES;

    public JWSHeader(JWSAlgorithm alg) {
        super(alg);
    }

    public static Set<String> getReservedParameterNames() {
        return RESERVED_PARAMETER_NAMES;
    }

    @Override
    public JWSAlgorithm getAlgorithm() {
        return (JWSAlgorithm)this.alg;
    }

    @Override
    public void setCustomParameter(String name, Object value) {
        if (JWSHeader.getReservedParameterNames().contains(name)) {
            throw new IllegalArgumentException("The parameter name \"" + name + "\" matches a reserved name");
        }
        super.setCustomParameter(name, value);
    }

    @Override
    public Set<String> getIncludedParameters() {
        HashSet<String> includedParameters = new HashSet<String>(this.getCustomParameters().keySet());
        includedParameters.add("alg");
        if (this.getType() != null) {
            includedParameters.add("typ");
        }
        if (this.getContentType() != null) {
            includedParameters.add("cty");
        }
        if (this.getJWKURL() != null) {
            includedParameters.add("jku");
        }
        if (this.getJWK() != null) {
            includedParameters.add("jwk");
        }
        if (this.getX509CertURL() != null) {
            includedParameters.add("x5u");
        }
        if (this.getX509CertThumbprint() != null) {
            includedParameters.add("x5t");
        }
        if (this.getX509CertChain() != null) {
            includedParameters.add("x5c");
        }
        if (this.getKeyID() != null) {
            includedParameters.add("kid");
        }
        return includedParameters;
    }

    public static JWSHeader parse(JSONObject json) throws ParseException {
        Algorithm alg = Header.parseAlgorithm(json);
        if (!(alg instanceof JWSAlgorithm)) {
            throw new ParseException("The algorithm \"alg\" header parameter must be for signatures", 0);
        }
        JWSHeader h = new JWSHeader((JWSAlgorithm)alg);
        for (String name : json.keySet()) {
            if (name.equals("alg")) continue;
            if (name.equals("typ")) {
                h.setType(new JOSEObjectType(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("cty")) {
                h.setContentType(JSONObjectUtils.getString(json, name));
                continue;
            }
            if (name.equals("jku")) {
                h.setJWKURL(JSONObjectUtils.getURL(json, name));
                continue;
            }
            if (name.equals("jwk")) {
                h.setJWK(JWK.parse(JSONObjectUtils.getJSONObject(json, name)));
                continue;
            }
            if (name.equals("x5u")) {
                h.setX509CertURL(JSONObjectUtils.getURL(json, name));
                continue;
            }
            if (name.equals("x5t")) {
                h.setX509CertThumbprint(new Base64URL(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("x5c")) {
                h.setX509CertChain(CommonSEHeader.parseX509CertChain(JSONObjectUtils.getJSONArray(json, name)));
                continue;
            }
            if (name.equals("kid")) {
                h.setKeyID(JSONObjectUtils.getString(json, name));
                continue;
            }
            h.setCustomParameter(name, json.get((Object)name));
        }
        return h;
    }

    public static JWSHeader parse(String s) throws ParseException {
        JSONObject jsonObject = JSONObjectUtils.parseJSONObject(s);
        return JWSHeader.parse(jsonObject);
    }

    public static JWSHeader parse(Base64URL base64URL) throws ParseException {
        JWSHeader header = JWSHeader.parse(base64URL.decodeToString());
        header.setParsedBase64URL(base64URL);
        return header;
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("alg");
        p.add("jku");
        p.add("jwk");
        p.add("x5u");
        p.add("x5t");
        p.add("x5c");
        p.add("kid");
        p.add("typ");
        p.add("cty");
        RESERVED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

