/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeaderFilter;
import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class DefaultJWSHeaderFilter
implements JWSHeaderFilter {
    private final Set<JWSAlgorithm> algs;
    private Set<JWSAlgorithm> acceptedAlgs;
    private final Set<String> acceptedParams;

    public DefaultJWSHeaderFilter(Set<JWSAlgorithm> algs, Set<String> acceptedParams) {
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWS algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
        this.acceptedAlgs = this.algs;
        if (acceptedParams == null) {
            throw new IllegalArgumentException("The accepted JWS header parameter set must not be null");
        }
        if (!acceptedParams.contains("alg")) {
            throw new IllegalArgumentException("The accepted JWE header parameter set must include at least the \"alg\" parameter");
        }
        this.acceptedParams = Collections.unmodifiableSet(acceptedParams);
    }

    public Set<JWSAlgorithm> supportedAlgorithms() {
        return this.algs;
    }

    @Override
    public Set<JWSAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWSAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWS algorithm set must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("One or more of the algorithms is not in the supported JWS algorithm set");
        }
        this.acceptedAlgs = Collections.unmodifiableSet(acceptedAlgs);
    }

    @Override
    public Set<String> getAcceptedParameters() {
        return this.acceptedParams;
    }
}

