/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.shutdown;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownManager.class);
    private Duration timeout;
    private ConcurrentMap<AutoCloseable, Integer> shutdownHooks = new ConcurrentHashMap<AutoCloseable, Integer>();

    public ShutdownManager(Duration timeout) {
        this.timeout = timeout;
    }

    public void addShutdownHook(AutoCloseable shutdownHook) {
        this.shutdownHooks.put(shutdownHook, 1);
    }

    @BeforeScopeEnd
    public void shutdown() {
        Map shutdownErrors;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Map> future = executor.submit(() -> this.shutdownAll());
        try {
            shutdownErrors = future.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e2) {
            shutdownErrors = Collections.singletonMap(this, e2);
        }
        executor.shutdownNow();
        shutdownErrors.forEach((c, e) -> LOGGER.warn("Error on shutdown", e));
    }

    protected Map<?, ? extends Throwable> shutdownAll() {
        HashMap errors = new HashMap();
        this.shutdownHooks.keySet().forEach(c -> this.shutdownOne((AutoCloseable)c).ifPresent(e -> {
            Throwable cfr_ignored_0 = errors.put(c, e);
        }));
        return errors;
    }

    protected Optional<Exception> shutdownOne(AutoCloseable closeable) {
        try {
            closeable.close();
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }
}

