/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.processor.update;

import com.nhl.link.rest.CompoundObjectId;
import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.EntityParent;
import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.LrObjectId;
import com.nhl.link.rest.ObjectMapperFactory;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.SimpleObjectId;
import com.nhl.link.rest.constraints.Constraint;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.processor.BaseProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class UpdateContext<T>
extends BaseProcessingContext<T> {
    private ResourceEntity<T> entity;
    private UriInfo uriInfo;
    private LrObjectId id;
    private EntityParent<?> parent;
    private Constraint<T> readConstraints;
    private Constraint<T> writeConstraints;
    private boolean includingDataInResponse;
    private ObjectMapperFactory mapper;
    private String entityData;
    private boolean idUpdatesDisallowed;
    private Collection<EntityUpdate<T>> updates;
    private Encoder encoder;
    private List objects;

    public UpdateContext(Class<T> type) {
        super(type);
    }

    public DataResponse<T> createDataResponse() {
        List objects = this.objects != null ? this.objects : Collections.emptyList();
        DataResponse response = DataResponse.forType(this.getType());
        response.setObjects(objects);
        response.setEncoder(this.encoder);
        response.setStatus(this.getStatus());
        return response;
    }

    public boolean hasChanges() {
        for (EntityUpdate<T> u : this.updates) {
            if (!u.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public Collection<EntityUpdate<T>> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<EntityUpdate<T>> updates) {
        this.updates = updates;
    }

    public EntityUpdate<T> getFirst() {
        Collection<EntityUpdate<T>> updates = this.getUpdates();
        if (updates.size() != 1) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Expected one object in update. Actual: " + updates.size());
        }
        return updates.iterator().next();
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public boolean isById() {
        return this.id != null;
    }

    public LrObjectId getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = new SimpleObjectId(id);
    }

    public void setCompoundId(Map<String, Object> ids) {
        this.id = new CompoundObjectId(ids);
    }

    public EntityParent<?> getParent() {
        return this.parent;
    }

    public void setParent(EntityParent<?> parent) {
        this.parent = parent;
    }

    public Constraint<T> getReadConstraints() {
        return this.readConstraints;
    }

    public void setReadConstraints(Constraint<T> readConstraints) {
        this.readConstraints = readConstraints;
    }

    public Constraint<T> getWriteConstraints() {
        return this.writeConstraints;
    }

    public void setWriteConstraints(Constraint<T> writeConstraints) {
        this.writeConstraints = writeConstraints;
    }

    public boolean isIncludingDataInResponse() {
        return this.includingDataInResponse;
    }

    public void setIncludingDataInResponse(boolean includeData) {
        this.includingDataInResponse = includeData;
    }

    public ObjectMapperFactory getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapperFactory mapper) {
        this.mapper = mapper;
    }

    public String getEntityData() {
        return this.entityData;
    }

    public void setEntityData(String entityData) {
        this.entityData = entityData;
    }

    public boolean isIdUpdatesDisallowed() {
        return this.idUpdatesDisallowed;
    }

    public void setIdUpdatesDisallowed(boolean idUpdatesDisallowed) {
        this.idUpdatesDisallowed = idUpdatesDisallowed;
    }

    public ResourceEntity<T> getEntity() {
        return this.entity;
    }

    public void setEntity(ResourceEntity<T> entity) {
        this.entity = entity;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public void setObjects(List<? extends T> objects) {
        this.objects = objects;
    }
}

