/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.processor.update;

import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.parser.IRequestParser;
import com.nhl.link.rest.runtime.parser.IUpdateParser;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.Collection;
import org.apache.cayenne.di.Inject;

public class ParseRequestStage
implements Processor<UpdateContext<?>> {
    private IRequestParser requestParser;
    private IUpdateParser updateParser;
    private IMetadataService metadataService;

    public ParseRequestStage(@Inject IRequestParser requestParser, @Inject IUpdateParser updateParser, @Inject IMetadataService metadataService) {
        this.requestParser = requestParser;
        this.updateParser = updateParser;
        this.metadataService = metadataService;
    }

    @Override
    public ProcessorOutcome execute(UpdateContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T> void doExecute(UpdateContext<T> context) {
        LrEntity entity = this.metadataService.getLrEntity(context.getType());
        ResourceEntity resourceEntity = this.requestParser.parseUpdate(entity, context.getUriInfo());
        context.setEntity(resourceEntity);
        if (context.getUpdates() == null) {
            Collection updates = this.updateParser.parse(entity, context.getEntityData());
            context.setUpdates(updates);
        }
    }
}

